/*
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
$(document).ready(function() {

    $(".click-title").mouseenter( function(    e){
        e.preventDefault();
        this.style.cursor="pointer";
    });
    $(".click-title").mousedown( function(event){
        event.preventDefault();
    });

    // Ugly code while this script is shared among several pages
    try{
        refreshHitsPerSecond(true);
    } catch(e){}
    try{
        refreshResponseTimeOverTime(true);
    } catch(e){}
    try{
        refreshResponseTimePercentiles();
    } catch(e){}
});


var responseTimePercentilesInfos = {
        data: {"result": {"minY": 5.0, "minX": 0.0, "maxY": 180123.0, "series": [{"data": [[0.0, 5.0], [0.1, 13.0], [0.2, 25.0], [0.3, 44.0], [0.4, 121.0], [0.5, 316.0], [0.6, 450.0], [0.7, 530.0], [0.8, 599.0], [0.9, 665.0], [1.0, 819.0], [1.1, 906.0], [1.2, 992.0], [1.3, 1021.0], [1.4, 1102.0], [1.5, 1137.0], [1.6, 1200.0], [1.7, 1258.0], [1.8, 1306.0], [1.9, 1338.0], [2.0, 1458.0], [2.1, 1509.0], [2.2, 1577.0], [2.3, 1619.0], [2.4, 1703.0], [2.5, 1823.0], [2.6, 1897.0], [2.7, 2024.0], [2.8, 2084.0], [2.9, 2204.0], [3.0, 2278.0], [3.1, 2303.0], [3.2, 2345.0], [3.3, 2396.0], [3.4, 2431.0], [3.5, 2523.0], [3.6, 2583.0], [3.7, 2619.0], [3.8, 2666.0], [3.9, 2710.0], [4.0, 2759.0], [4.1, 2785.0], [4.2, 2806.0], [4.3, 2862.0], [4.4, 2891.0], [4.5, 2918.0], [4.6, 2945.0], [4.7, 2976.0], [4.8, 3008.0], [4.9, 3083.0], [5.0, 3173.0], [5.1, 3289.0], [5.2, 3328.0], [5.3, 3393.0], [5.4, 3503.0], [5.5, 3685.0], [5.6, 3799.0], [5.7, 3883.0], [5.8, 3961.0], [5.9, 4012.0], [6.0, 4102.0], [6.1, 4165.0], [6.2, 4223.0], [6.3, 4336.0], [6.4, 4389.0], [6.5, 4576.0], [6.6, 4782.0], [6.7, 4922.0], [6.8, 5060.0], [6.9, 5354.0], [7.0, 5420.0], [7.1, 5681.0], [7.2, 5820.0], [7.3, 6227.0], [7.4, 6503.0], [7.5, 6647.0], [7.6, 6848.0], [7.7, 6974.0], [7.8, 7179.0], [7.9, 7338.0], [8.0, 7500.0], [8.1, 7594.0], [8.2, 7779.0], [8.3, 7931.0], [8.4, 8057.0], [8.5, 8301.0], [8.6, 8417.0], [8.7, 8551.0], [8.8, 8725.0], [8.9, 9063.0], [9.0, 9134.0], [9.1, 9211.0], [9.2, 9488.0], [9.3, 9612.0], [9.4, 9789.0], [9.5, 9877.0], [9.6, 9988.0], [9.7, 10104.0], [9.8, 10278.0], [9.9, 10500.0], [10.0, 10692.0], [10.1, 10827.0], [10.2, 10981.0], [10.3, 11159.0], [10.4, 11264.0], [10.5, 11462.0], [10.6, 11610.0], [10.7, 11811.0], [10.8, 12009.0], [10.9, 12083.0], [11.0, 12183.0], [11.1, 12561.0], [11.2, 12608.0], [11.3, 12772.0], [11.4, 12912.0], [11.5, 12993.0], [11.6, 13120.0], [11.7, 13296.0], [11.8, 13411.0], [11.9, 13714.0], [12.0, 13957.0], [12.1, 14093.0], [12.2, 14224.0], [12.3, 14292.0], [12.4, 14393.0], [12.5, 14453.0], [12.6, 14580.0], [12.7, 14629.0], [12.8, 14810.0], [12.9, 14954.0], [13.0, 15082.0], [13.1, 15198.0], [13.2, 15387.0], [13.3, 15466.0], [13.4, 15542.0], [13.5, 15656.0], [13.6, 15711.0], [13.7, 15866.0], [13.8, 15900.0], [13.9, 16062.0], [14.0, 16179.0], [14.1, 16229.0], [14.2, 16288.0], [14.3, 16310.0], [14.4, 16406.0], [14.5, 16500.0], [14.6, 16591.0], [14.7, 16722.0], [14.8, 16874.0], [14.9, 16977.0], [15.0, 17054.0], [15.1, 17232.0], [15.2, 17421.0], [15.3, 17516.0], [15.4, 17609.0], [15.5, 17744.0], [15.6, 17895.0], [15.7, 17992.0], [15.8, 18087.0], [15.9, 18149.0], [16.0, 18313.0], [16.1, 18468.0], [16.2, 18557.0], [16.3, 18647.0], [16.4, 18780.0], [16.5, 18810.0], [16.6, 18908.0], [16.7, 18985.0], [16.8, 19145.0], [16.9, 19185.0], [17.0, 19315.0], [17.1, 19410.0], [17.2, 19599.0], [17.3, 19655.0], [17.4, 19677.0], [17.5, 19745.0], [17.6, 19860.0], [17.7, 19981.0], [17.8, 20102.0], [17.9, 20147.0], [18.0, 20239.0], [18.1, 20331.0], [18.2, 20447.0], [18.3, 20559.0], [18.4, 20651.0], [18.5, 20811.0], [18.6, 20868.0], [18.7, 21023.0], [18.8, 21130.0], [18.9, 21305.0], [19.0, 21464.0], [19.1, 21506.0], [19.2, 21618.0], [19.3, 21803.0], [19.4, 22030.0], [19.5, 22106.0], [19.6, 22257.0], [19.7, 22393.0], [19.8, 22589.0], [19.9, 22657.0], [20.0, 22882.0], [20.1, 23122.0], [20.2, 23219.0], [20.3, 23287.0], [20.4, 23411.0], [20.5, 23509.0], [20.6, 23612.0], [20.7, 23821.0], [20.8, 23935.0], [20.9, 24118.0], [21.0, 24281.0], [21.1, 24403.0], [21.2, 24619.0], [21.3, 24769.0], [21.4, 24897.0], [21.5, 25114.0], [21.6, 25204.0], [21.7, 25317.0], [21.8, 25483.0], [21.9, 25693.0], [22.0, 25881.0], [22.1, 25978.0], [22.2, 26189.0], [22.3, 26325.0], [22.4, 26407.0], [22.5, 26594.0], [22.6, 26760.0], [22.7, 26942.0], [22.8, 27091.0], [22.9, 27219.0], [23.0, 27353.0], [23.1, 27415.0], [23.2, 27696.0], [23.3, 27841.0], [23.4, 27999.0], [23.5, 28348.0], [23.6, 28515.0], [23.7, 28591.0], [23.8, 28713.0], [23.9, 28773.0], [24.0, 28976.0], [24.1, 29070.0], [24.2, 29281.0], [24.3, 29413.0], [24.4, 29572.0], [24.5, 29694.0], [24.6, 29811.0], [24.7, 29964.0], [24.8, 30077.0], [24.9, 30178.0], [25.0, 30338.0], [25.1, 30426.0], [25.2, 30581.0], [25.3, 30748.0], [25.4, 30851.0], [25.5, 31040.0], [25.6, 31201.0], [25.7, 31327.0], [25.8, 31445.0], [25.9, 31556.0], [26.0, 31798.0], [26.1, 31887.0], [26.2, 32083.0], [26.3, 32126.0], [26.4, 32254.0], [26.5, 32410.0], [26.6, 32548.0], [26.7, 32709.0], [26.8, 32876.0], [26.9, 32993.0], [27.0, 33071.0], [27.1, 33219.0], [27.2, 33435.0], [27.3, 33523.0], [27.4, 33615.0], [27.5, 33735.0], [27.6, 33853.0], [27.7, 33949.0], [27.8, 34097.0], [27.9, 34209.0], [28.0, 34338.0], [28.1, 34441.0], [28.2, 34643.0], [28.3, 34764.0], [28.4, 34838.0], [28.5, 34965.0], [28.6, 35008.0], [28.7, 35095.0], [28.8, 35170.0], [28.9, 35261.0], [29.0, 35387.0], [29.1, 35448.0], [29.2, 35520.0], [29.3, 35570.0], [29.4, 35723.0], [29.5, 35784.0], [29.6, 35823.0], [29.7, 35871.0], [29.8, 36003.0], [29.9, 36045.0], [30.0, 36096.0], [30.1, 36194.0], [30.2, 36314.0], [30.3, 36494.0], [30.4, 36568.0], [30.5, 36698.0], [30.6, 36762.0], [30.7, 36870.0], [30.8, 36938.0], [30.9, 36990.0], [31.0, 37093.0], [31.1, 37159.0], [31.2, 37232.0], [31.3, 37317.0], [31.4, 37363.0], [31.5, 37424.0], [31.6, 37520.0], [31.7, 37691.0], [31.8, 37772.0], [31.9, 37835.0], [32.0, 37933.0], [32.1, 38072.0], [32.2, 38101.0], [32.3, 38155.0], [32.4, 38233.0], [32.5, 38286.0], [32.6, 38350.0], [32.7, 38405.0], [32.8, 38511.0], [32.9, 38545.0], [33.0, 38568.0], [33.1, 38637.0], [33.2, 38691.0], [33.3, 38807.0], [33.4, 38902.0], [33.5, 38997.0], [33.6, 39125.0], [33.7, 39192.0], [33.8, 39269.0], [33.9, 39358.0], [34.0, 39407.0], [34.1, 39464.0], [34.2, 39502.0], [34.3, 39538.0], [34.4, 39633.0], [34.5, 39742.0], [34.6, 39794.0], [34.7, 39883.0], [34.8, 39905.0], [34.9, 39957.0], [35.0, 40023.0], [35.1, 40093.0], [35.2, 40158.0], [35.3, 40221.0], [35.4, 40318.0], [35.5, 40409.0], [35.6, 40482.0], [35.7, 40562.0], [35.8, 40654.0], [35.9, 40739.0], [36.0, 40787.0], [36.1, 40818.0], [36.2, 40891.0], [36.3, 40919.0], [36.4, 41071.0], [36.5, 41099.0], [36.6, 41130.0], [36.7, 41196.0], [36.8, 41310.0], [36.9, 41520.0], [37.0, 41554.0], [37.1, 41618.0], [37.2, 41752.0], [37.3, 41822.0], [37.4, 41880.0], [37.5, 41954.0], [37.6, 42080.0], [37.7, 42162.0], [37.8, 42259.0], [37.9, 42379.0], [38.0, 42489.0], [38.1, 42613.0], [38.2, 42653.0], [38.3, 42697.0], [38.4, 42783.0], [38.5, 42856.0], [38.6, 42880.0], [38.7, 42943.0], [38.8, 42979.0], [38.9, 43074.0], [39.0, 43174.0], [39.1, 43290.0], [39.2, 43358.0], [39.3, 43452.0], [39.4, 43495.0], [39.5, 43585.0], [39.6, 43681.0], [39.7, 43734.0], [39.8, 43800.0], [39.9, 43910.0], [40.0, 43978.0], [40.1, 44026.0], [40.2, 44117.0], [40.3, 44179.0], [40.4, 44278.0], [40.5, 44396.0], [40.6, 44464.0], [40.7, 44513.0], [40.8, 44580.0], [40.9, 44619.0], [41.0, 44707.0], [41.1, 44781.0], [41.2, 44851.0], [41.3, 44919.0], [41.4, 44979.0], [41.5, 45030.0], [41.6, 45142.0], [41.7, 45223.0], [41.8, 45272.0], [41.9, 45313.0], [42.0, 45371.0], [42.1, 45412.0], [42.2, 45484.0], [42.3, 45578.0], [42.4, 45621.0], [42.5, 45710.0], [42.6, 45794.0], [42.7, 45853.0], [42.8, 45911.0], [42.9, 45987.0], [43.0, 46093.0], [43.1, 46176.0], [43.2, 46260.0], [43.3, 46289.0], [43.4, 46343.0], [43.5, 46399.0], [43.6, 46425.0], [43.7, 46501.0], [43.8, 46547.0], [43.9, 46613.0], [44.0, 46728.0], [44.1, 46799.0], [44.2, 46891.0], [44.3, 46925.0], [44.4, 47017.0], [44.5, 47108.0], [44.6, 47130.0], [44.7, 47263.0], [44.8, 47350.0], [44.9, 47404.0], [45.0, 47508.0], [45.1, 47567.0], [45.2, 47606.0], [45.3, 47650.0], [45.4, 47780.0], [45.5, 47825.0], [45.6, 47927.0], [45.7, 47966.0], [45.8, 48066.0], [45.9, 48103.0], [46.0, 48238.0], [46.1, 48294.0], [46.2, 48387.0], [46.3, 48476.0], [46.4, 48510.0], [46.5, 48595.0], [46.6, 48684.0], [46.7, 48756.0], [46.8, 48787.0], [46.9, 48856.0], [47.0, 48970.0], [47.1, 49083.0], [47.2, 49173.0], [47.3, 49316.0], [47.4, 49389.0], [47.5, 49479.0], [47.6, 49514.0], [47.7, 49598.0], [47.8, 49735.0], [47.9, 49815.0], [48.0, 49901.0], [48.1, 50003.0], [48.2, 50091.0], [48.3, 50168.0], [48.4, 50207.0], [48.5, 50297.0], [48.6, 50404.0], [48.7, 50490.0], [48.8, 50545.0], [48.9, 50622.0], [49.0, 50692.0], [49.1, 50777.0], [49.2, 50870.0], [49.3, 50892.0], [49.4, 50968.0], [49.5, 51009.0], [49.6, 51101.0], [49.7, 51177.0], [49.8, 51265.0], [49.9, 51395.0], [50.0, 51523.0], [50.1, 51662.0], [50.2, 51729.0], [50.3, 51900.0], [50.4, 52015.0], [50.5, 52108.0], [50.6, 52209.0], [50.7, 52406.0], [50.8, 52483.0], [50.9, 52556.0], [51.0, 52679.0], [51.1, 52861.0], [51.2, 53102.0], [51.3, 53221.0], [51.4, 53429.0], [51.5, 53591.0], [51.6, 53693.0], [51.7, 53882.0], [51.8, 53950.0], [51.9, 54071.0], [52.0, 54136.0], [52.1, 54355.0], [52.2, 54480.0], [52.3, 54575.0], [52.4, 54714.0], [52.5, 54882.0], [52.6, 54924.0], [52.7, 54997.0], [52.8, 55156.0], [52.9, 55317.0], [53.0, 55518.0], [53.1, 55605.0], [53.2, 55783.0], [53.3, 55911.0], [53.4, 56013.0], [53.5, 56085.0], [53.6, 56195.0], [53.7, 56370.0], [53.8, 56534.0], [53.9, 56648.0], [54.0, 56738.0], [54.1, 56904.0], [54.2, 57071.0], [54.3, 57176.0], [54.4, 57282.0], [54.5, 57426.0], [54.6, 57637.0], [54.7, 57784.0], [54.8, 57876.0], [54.9, 57958.0], [55.0, 58137.0], [55.1, 58368.0], [55.2, 58539.0], [55.3, 58659.0], [55.4, 58835.0], [55.5, 58981.0], [55.6, 59209.0], [55.7, 59785.0], [55.8, 59936.0], [55.9, 60113.0], [56.0, 60171.0], [56.1, 60391.0], [56.2, 60599.0], [56.3, 60807.0], [56.4, 61627.0], [56.5, 62467.0], [56.6, 63319.0], [56.7, 63555.0], [56.8, 64099.0], [56.9, 64529.0], [57.0, 64850.0], [57.1, 65296.0], [57.2, 65404.0], [57.3, 65539.0], [57.4, 65782.0], [57.5, 66224.0], [57.6, 66377.0], [57.7, 66510.0], [57.8, 66604.0], [57.9, 66740.0], [58.0, 66879.0], [58.1, 66974.0], [58.2, 67084.0], [58.3, 67200.0], [58.4, 67366.0], [58.5, 67502.0], [58.6, 67625.0], [58.7, 67785.0], [58.8, 67857.0], [58.9, 68087.0], [59.0, 68276.0], [59.1, 68483.0], [59.2, 68563.0], [59.3, 68636.0], [59.4, 68804.0], [59.5, 68959.0], [59.6, 69135.0], [59.7, 69333.0], [59.8, 69509.0], [59.9, 69792.0], [60.0, 69981.0], [60.1, 70201.0], [60.2, 70350.0], [60.3, 70602.0], [60.4, 70947.0], [60.5, 71520.0], [60.6, 71787.0], [60.7, 72293.0], [60.8, 72526.0], [60.9, 72715.0], [61.0, 72883.0], [61.1, 73046.0], [61.2, 73221.0], [61.3, 73587.0], [61.4, 73868.0], [61.5, 74293.0], [61.6, 74575.0], [61.7, 74948.0], [61.8, 75255.0], [61.9, 75531.0], [62.0, 75669.0], [62.1, 75918.0], [62.2, 76159.0], [62.3, 76363.0], [62.4, 76637.0], [62.5, 76903.0], [62.6, 77117.0], [62.7, 77403.0], [62.8, 77745.0], [62.9, 78029.0], [63.0, 78257.0], [63.1, 78427.0], [63.2, 78810.0], [63.3, 79088.0], [63.4, 79272.0], [63.5, 79521.0], [63.6, 80104.0], [63.7, 80584.0], [63.8, 80956.0], [63.9, 81600.0], [64.0, 81814.0], [64.1, 82014.0], [64.2, 82998.0], [64.3, 83595.0], [64.4, 84110.0], [64.5, 84690.0], [64.6, 85387.0], [64.7, 85884.0], [64.8, 86120.0], [64.9, 86500.0], [65.0, 87001.0], [65.1, 87206.0], [65.2, 87763.0], [65.3, 88012.0], [65.4, 88487.0], [65.5, 88811.0], [65.6, 89312.0], [65.7, 89737.0], [65.8, 90222.0], [65.9, 90477.0], [66.0, 91389.0], [66.1, 91619.0], [66.2, 91954.0], [66.3, 92094.0], [66.4, 92330.0], [66.5, 92608.0], [66.6, 92736.0], [66.7, 92873.0], [66.8, 92983.0], [66.9, 93092.0], [67.0, 93178.0], [67.1, 93448.0], [67.2, 93569.0], [67.3, 93682.0], [67.4, 93779.0], [67.5, 93938.0], [67.6, 94102.0], [67.7, 94242.0], [67.8, 94373.0], [67.9, 94458.0], [68.0, 94524.0], [68.1, 94616.0], [68.2, 94682.0], [68.3, 94880.0], [68.4, 94970.0], [68.5, 95054.0], [68.6, 95138.0], [68.7, 95270.0], [68.8, 95360.0], [68.9, 95513.0], [69.0, 95583.0], [69.1, 95892.0], [69.2, 96069.0], [69.3, 96233.0], [69.4, 96331.0], [69.5, 96502.0], [69.6, 96672.0], [69.7, 96780.0], [69.8, 96907.0], [69.9, 97074.0], [70.0, 97384.0], [70.1, 97486.0], [70.2, 97594.0], [70.3, 97802.0], [70.4, 97911.0], [70.5, 98037.0], [70.6, 98173.0], [70.7, 98304.0], [70.8, 98413.0], [70.9, 98490.0], [71.0, 98813.0], [71.1, 98999.0], [71.2, 99182.0], [71.3, 99318.0], [71.4, 99622.0], [71.5, 99788.0], [71.6, 99902.0], [71.7, 100000.0], [71.8, 100091.0], [71.9, 100149.0], [72.0, 100243.0], [72.1, 100366.0], [72.2, 100423.0], [72.3, 100536.0], [72.4, 100664.0], [72.5, 100806.0], [72.6, 100909.0], [72.7, 101037.0], [72.8, 101161.0], [72.9, 101178.0], [73.0, 101230.0], [73.1, 101314.0], [73.2, 101426.0], [73.3, 101506.0], [73.4, 101595.0], [73.5, 101697.0], [73.6, 101855.0], [73.7, 101916.0], [73.8, 102044.0], [73.9, 102195.0], [74.0, 102230.0], [74.1, 102382.0], [74.2, 102495.0], [74.3, 102596.0], [74.4, 102744.0], [74.5, 102870.0], [74.6, 102976.0], [74.7, 103096.0], [74.8, 103243.0], [74.9, 103319.0], [75.0, 103449.0], [75.1, 103538.0], [75.2, 103646.0], [75.3, 103742.0], [75.4, 103853.0], [75.5, 103963.0], [75.6, 104032.0], [75.7, 104245.0], [75.8, 104303.0], [75.9, 104444.0], [76.0, 104619.0], [76.1, 104727.0], [76.2, 104916.0], [76.3, 105059.0], [76.4, 105263.0], [76.5, 105544.0], [76.6, 105771.0], [76.7, 106022.0], [76.8, 106337.0], [76.9, 106664.0], [77.0, 106979.0], [77.1, 107282.0], [77.2, 107482.0], [77.3, 107710.0], [77.4, 108195.0], [77.5, 108690.0], [77.6, 108945.0], [77.7, 109701.0], [77.8, 110085.0], [77.9, 110550.0], [78.0, 111232.0], [78.1, 112108.0], [78.2, 113061.0], [78.3, 113584.0], [78.4, 114166.0], [78.5, 114533.0], [78.6, 115087.0], [78.7, 115769.0], [78.8, 116193.0], [78.9, 116479.0], [79.0, 116691.0], [79.1, 117019.0], [79.2, 117197.0], [79.3, 117510.0], [79.4, 117717.0], [79.5, 118233.0], [79.6, 118585.0], [79.7, 118740.0], [79.8, 119156.0], [79.9, 119242.0], [80.0, 119593.0], [80.1, 119757.0], [80.2, 120004.0], [80.3, 120006.0], [80.4, 120008.0], [80.5, 120008.0], [80.6, 120010.0], [80.7, 120010.0], [80.8, 120011.0], [80.9, 120012.0], [81.0, 120013.0], [81.1, 120014.0], [81.2, 120022.0], [81.3, 120075.0], [81.4, 120081.0], [81.5, 120088.0], [81.6, 120094.0], [81.7, 120101.0], [81.8, 120106.0], [81.9, 120110.0], [82.0, 120116.0], [82.1, 120121.0], [82.2, 120127.0], [82.3, 120138.0], [82.4, 120164.0], [82.5, 120194.0], [82.6, 120207.0], [82.7, 120248.0], [82.8, 120359.0], [82.9, 120753.0], [83.0, 121494.0], [83.1, 123135.0], [83.2, 124339.0], [83.3, 125430.0], [83.4, 126306.0], [83.5, 127568.0], [83.6, 128799.0], [83.7, 130529.0], [83.8, 132713.0], [83.9, 133730.0], [84.0, 134585.0], [84.1, 136371.0], [84.2, 136879.0], [84.3, 137588.0], [84.4, 138193.0], [84.5, 139031.0], [84.6, 139812.0], [84.7, 141204.0], [84.8, 141854.0], [84.9, 142930.0], [85.0, 143839.0], [85.1, 144727.0], [85.2, 145659.0], [85.3, 146885.0], [85.4, 147895.0], [85.5, 148615.0], [85.6, 149580.0], [85.7, 150857.0], [85.8, 151448.0], [85.9, 151951.0], [86.0, 152683.0], [86.1, 153514.0], [86.2, 154133.0], [86.3, 154855.0], [86.4, 155417.0], [86.5, 155770.0], [86.6, 156514.0], [86.7, 156810.0], [86.8, 157364.0], [86.9, 157909.0], [87.0, 158472.0], [87.1, 158938.0], [87.2, 159409.0], [87.3, 160184.0], [87.4, 160432.0], [87.5, 160951.0], [87.6, 161402.0], [87.7, 161790.0], [87.8, 162233.0], [87.9, 162500.0], [88.0, 162847.0], [88.1, 163288.0], [88.2, 163511.0], [88.3, 163949.0], [88.4, 164331.0], [88.5, 164602.0], [88.6, 164849.0], [88.7, 165171.0], [88.8, 165730.0], [88.9, 166049.0], [89.0, 166357.0], [89.1, 166601.0], [89.2, 166847.0], [89.3, 167021.0], [89.4, 167293.0], [89.5, 167485.0], [89.6, 167686.0], [89.7, 168081.0], [89.8, 168343.0], [89.9, 168601.0], [90.0, 168941.0], [90.1, 169276.0], [90.2, 169506.0], [90.3, 169852.0], [90.4, 170261.0], [90.5, 170522.0], [90.6, 170733.0], [90.7, 171114.0], [90.8, 171295.0], [90.9, 171585.0], [91.0, 172185.0], [91.1, 172386.0], [91.2, 172622.0], [91.3, 173032.0], [91.4, 173210.0], [91.5, 173378.0], [91.6, 173742.0], [91.7, 174132.0], [91.8, 174540.0], [91.9, 174776.0], [92.0, 174999.0], [92.1, 175284.0], [92.2, 175913.0], [92.3, 176961.0], [92.4, 177325.0], [92.5, 178258.0], [92.6, 178832.0], [92.7, 179717.0], [92.8, 180004.0], [92.9, 180004.0], [93.0, 180005.0], [93.1, 180005.0], [93.2, 180005.0], [93.3, 180005.0], [93.4, 180005.0], [93.5, 180005.0], [93.6, 180005.0], [93.7, 180006.0], [93.8, 180006.0], [93.9, 180006.0], [94.0, 180006.0], [94.1, 180007.0], [94.2, 180007.0], [94.3, 180007.0], [94.4, 180008.0], [94.5, 180008.0], [94.6, 180009.0], [94.7, 180009.0], [94.8, 180009.0], [94.9, 180010.0], [95.0, 180010.0], [95.1, 180010.0], [95.2, 180011.0], [95.3, 180011.0], [95.4, 180011.0], [95.5, 180012.0], [95.6, 180012.0], [95.7, 180013.0], [95.8, 180013.0], [95.9, 180013.0], [96.0, 180013.0], [96.1, 180013.0], [96.2, 180014.0], [96.3, 180014.0], [96.4, 180014.0], [96.5, 180014.0], [96.6, 180015.0], [96.7, 180015.0], [96.8, 180015.0], [96.9, 180016.0], [97.0, 180016.0], [97.1, 180016.0], [97.2, 180017.0], [97.3, 180017.0], [97.4, 180017.0], [97.5, 180017.0], [97.6, 180018.0], [97.7, 180018.0], [97.8, 180018.0], [97.9, 180018.0], [98.0, 180019.0], [98.1, 180019.0], [98.2, 180020.0], [98.3, 180020.0], [98.4, 180020.0], [98.5, 180021.0], [98.6, 180021.0], [98.7, 180021.0], [98.8, 180022.0], [98.9, 180022.0], [99.0, 180022.0], [99.1, 180023.0], [99.2, 180023.0], [99.3, 180024.0], [99.4, 180025.0], [99.5, 180026.0], [99.6, 180026.0], [99.7, 180029.0], [99.8, 180030.0], [99.9, 180044.0]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 100.0, "title": "Response Time Percentiles"}},
        getOptions: function() {
            return {
                series: {
                    points: { show: false }
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentiles'
                },
                xaxis: {
                    tickDecimals: 1,
                    axisLabel: "Percentiles",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Percentile value in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : %x.2 percentile was %y ms"
                },
                selection: { mode: "xy" },
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentiles"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesPercentiles"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesPercentiles"), dataset, prepareOverviewOptions(options));
        }
};

/**
 * @param elementId Id of element where we display message
 */
function setEmptyGraph(elementId) {
    $(function() {
        $(elementId).text("No graph series with filter="+seriesFilter);
    });
}

// Response times percentiles
function refreshResponseTimePercentiles() {
    var infos = responseTimePercentilesInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimePercentiles");
        return;
    }
    if (isGraph($("#flotResponseTimesPercentiles"))){
        infos.createGraph();
    } else {
        var choiceContainer = $("#choicesResponseTimePercentiles");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesPercentiles", "#overviewResponseTimesPercentiles");
        $('#bodyResponseTimePercentiles .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimeDistributionInfos = {
        data: {"result": {"minY": 1.0, "minX": 0.0, "maxY": 468.0, "series": [{"data": [[0.0, 23.0], [154400.0, 1.0], [148000.0, 1.0], [160800.0, 1.0], [167200.0, 2.0], [180000.0, 468.0], [173600.0, 1.0], [132900.0, 1.0], [139300.0, 1.0], [152100.0, 2.0], [164900.0, 2.0], [171300.0, 1.0], [66700.0, 3.0], [69900.0, 3.0], [73100.0, 2.0], [76300.0, 1.0], [79500.0, 2.0], [85900.0, 1.0], [82700.0, 1.0], [89100.0, 1.0], [92300.0, 3.0], [95500.0, 11.0], [101900.0, 5.0], [105100.0, 5.0], [111500.0, 2.0], [114700.0, 1.0], [117900.0, 1.0], [121100.0, 1.0], [124300.0, 1.0], [127500.0, 1.0], [130700.0, 1.0], [156200.0, 1.0], [169000.0, 1.0], [100.0, 6.0], [34500.0, 3.0], [32900.0, 5.0], [36100.0, 7.0], [37700.0, 10.0], [147500.0, 1.0], [40900.0, 7.0], [39300.0, 11.0], [160300.0, 2.0], [42500.0, 2.0], [166700.0, 1.0], [44100.0, 10.0], [173100.0, 2.0], [45700.0, 8.0], [48900.0, 4.0], [47300.0, 9.0], [50500.0, 6.0], [200.0, 2.0], [52100.0, 7.0], [53700.0, 1.0], [55300.0, 4.0], [56900.0, 1.0], [58500.0, 4.0], [60100.0, 8.0], [61700.0, 1.0], [63300.0, 2.0], [69000.0, 2.0], [72200.0, 2.0], [300.0, 5.0], [75400.0, 1.0], [81800.0, 3.0], [88200.0, 2.0], [91400.0, 2.0], [94600.0, 9.0], [97800.0, 6.0], [101000.0, 3.0], [400.0, 5.0], [104200.0, 6.0], [107400.0, 6.0], [113800.0, 1.0], [110600.0, 1.0], [117000.0, 4.0], [120200.0, 13.0], [126600.0, 1.0], [500.0, 11.0], [129800.0, 1.0], [138800.0, 1.0], [145200.0, 1.0], [600.0, 8.0], [158000.0, 1.0], [164400.0, 1.0], [700.0, 4.0], [177200.0, 2.0], [800.0, 4.0], [900.0, 12.0], [1000.0, 10.0], [1100.0, 13.0], [1200.0, 12.0], [1300.0, 9.0], [1400.0, 10.0], [1500.0, 12.0], [1600.0, 8.0], [1700.0, 5.0], [1800.0, 9.0], [1900.0, 4.0], [2000.0, 12.0], [2100.0, 2.0], [136500.0, 1.0], [2200.0, 12.0], [2300.0, 15.0], [142900.0, 1.0], [2400.0, 12.0], [2500.0, 11.0], [155700.0, 3.0], [2600.0, 14.0], [168500.0, 2.0], [2800.0, 18.0], [2700.0, 18.0], [174900.0, 3.0], [2900.0, 21.0], [3000.0, 12.0], [3100.0, 7.0], [3300.0, 13.0], [3200.0, 4.0], [3400.0, 4.0], [3500.0, 5.0], [3700.0, 6.0], [3600.0, 3.0], [3800.0, 10.0], [3900.0, 5.0], [4000.0, 10.0], [4200.0, 6.0], [68100.0, 3.0], [4600.0, 3.0], [4400.0, 2.0], [71300.0, 1.0], [4800.0, 4.0], [74500.0, 5.0], [77700.0, 2.0], [5000.0, 5.0], [80900.0, 4.0], [5200.0, 2.0], [84100.0, 1.0], [5400.0, 6.0], [5600.0, 2.0], [5800.0, 4.0], [93700.0, 5.0], [6000.0, 1.0], [96900.0, 3.0], [6200.0, 2.0], [100100.0, 11.0], [6600.0, 4.0], [6400.0, 1.0], [103300.0, 7.0], [6800.0, 5.0], [109700.0, 2.0], [106500.0, 1.0], [7000.0, 4.0], [112900.0, 1.0], [7400.0, 4.0], [7200.0, 4.0], [116100.0, 3.0], [7600.0, 4.0], [119300.0, 1.0], [122500.0, 1.0], [7800.0, 2.0], [8000.0, 4.0], [8400.0, 4.0], [134200.0, 1.0], [9200.0, 4.0], [8800.0, 1.0], [147000.0, 1.0], [9600.0, 5.0], [10000.0, 2.0], [159800.0, 1.0], [10400.0, 1.0], [166200.0, 2.0], [10800.0, 8.0], [11200.0, 7.0], [172600.0, 2.0], [179000.0, 1.0], [11600.0, 3.0], [12000.0, 8.0], [12800.0, 5.0], [13200.0, 4.0], [14000.0, 6.0], [14400.0, 5.0], [14800.0, 3.0], [15200.0, 3.0], [15600.0, 9.0], [16000.0, 7.0], [16800.0, 5.0], [18400.0, 7.0], [17600.0, 6.0], [19200.0, 5.0], [20000.0, 5.0], [20800.0, 9.0], [21600.0, 5.0], [22400.0, 2.0], [23200.0, 11.0], [24000.0, 3.0], [24800.0, 6.0], [25600.0, 3.0], [26400.0, 1.0], [27200.0, 6.0], [28000.0, 1.0], [28800.0, 3.0], [29600.0, 6.0], [30400.0, 4.0], [31200.0, 6.0], [32000.0, 6.0], [33600.0, 4.0], [35200.0, 5.0], [36800.0, 8.0], [144700.0, 1.0], [38400.0, 7.0], [40000.0, 8.0], [157500.0, 2.0], [41600.0, 8.0], [163900.0, 3.0], [170300.0, 2.0], [43200.0, 6.0], [44800.0, 8.0], [176700.0, 1.0], [46400.0, 12.0], [48000.0, 7.0], [49600.0, 5.0], [52800.0, 5.0], [51200.0, 5.0], [54400.0, 6.0], [56000.0, 9.0], [57600.0, 3.0], [59200.0, 4.0], [60800.0, 1.0], [62400.0, 2.0], [64000.0, 1.0], [67200.0, 2.0], [70400.0, 4.0], [73600.0, 2.0], [76800.0, 4.0], [83200.0, 2.0], [89600.0, 3.0], [86400.0, 2.0], [92800.0, 3.0], [96000.0, 3.0], [99200.0, 4.0], [102400.0, 6.0], [105600.0, 4.0], [108800.0, 1.0], [112000.0, 1.0], [118400.0, 1.0], [115200.0, 1.0], [153600.0, 1.0], [160000.0, 1.0], [166400.0, 3.0], [172800.0, 2.0], [132100.0, 2.0], [138500.0, 2.0], [151300.0, 3.0], [157700.0, 1.0], [170500.0, 1.0], [176900.0, 2.0], [67100.0, 4.0], [70300.0, 5.0], [73500.0, 3.0], [76700.0, 2.0], [79900.0, 2.0], [83100.0, 1.0], [86300.0, 1.0], [89500.0, 3.0], [92700.0, 5.0], [95900.0, 3.0], [102300.0, 7.0], [99100.0, 3.0], [105500.0, 2.0], [108700.0, 3.0], [118300.0, 2.0], [115100.0, 1.0], [124700.0, 2.0], [155400.0, 2.0], [161800.0, 1.0], [168200.0, 4.0], [174600.0, 2.0], [33100.0, 5.0], [34700.0, 6.0], [133900.0, 1.0], [36300.0, 3.0], [37900.0, 5.0], [39500.0, 9.0], [41100.0, 13.0], [42700.0, 7.0], [165900.0, 3.0], [44300.0, 3.0], [172300.0, 2.0], [178700.0, 1.0], [45900.0, 9.0], [47500.0, 13.0], [49100.0, 4.0], [50700.0, 8.0], [52300.0, 3.0], [53900.0, 5.0], [57100.0, 7.0], [55500.0, 6.0], [58700.0, 2.0], [60300.0, 4.0], [61900.0, 1.0], [63500.0, 4.0], [65100.0, 2.0], [66200.0, 7.0], [69400.0, 2.0], [72600.0, 1.0], [75800.0, 3.0], [79000.0, 2.0], [85400.0, 1.0], [82200.0, 1.0], [88600.0, 2.0], [91800.0, 3.0], [98200.0, 4.0], [95000.0, 5.0], [101400.0, 7.0], [104600.0, 7.0], [107800.0, 1.0], [114200.0, 1.0], [120600.0, 1.0], [138000.0, 1.0], [144400.0, 1.0], [150800.0, 1.0], [176400.0, 1.0], [135700.0, 1.0], [142100.0, 1.0], [154900.0, 2.0], [161300.0, 2.0], [174100.0, 1.0], [68500.0, 5.0], [71700.0, 2.0], [74900.0, 3.0], [78100.0, 3.0], [81300.0, 1.0], [84500.0, 1.0], [87700.0, 2.0], [90900.0, 2.0], [94100.0, 3.0], [97300.0, 4.0], [100500.0, 6.0], [103700.0, 8.0], [106900.0, 2.0], [116500.0, 3.0], [119700.0, 4.0], [122900.0, 3.0], [139800.0, 2.0], [152600.0, 1.0], [159000.0, 2.0], [165400.0, 1.0], [178200.0, 2.0], [16900.0, 6.0], [17700.0, 3.0], [18500.0, 9.0], [19300.0, 6.0], [20100.0, 11.0], [20900.0, 3.0], [21700.0, 3.0], [22500.0, 5.0], [23300.0, 3.0], [24100.0, 5.0], [24900.0, 3.0], [25700.0, 3.0], [26500.0, 6.0], [27300.0, 8.0], [28100.0, 2.0], [28900.0, 3.0], [29700.0, 3.0], [30500.0, 5.0], [31300.0, 4.0], [32100.0, 6.0], [33800.0, 3.0], [137500.0, 3.0], [35400.0, 7.0], [143900.0, 1.0], [38600.0, 11.0], [150300.0, 3.0], [37000.0, 8.0], [40200.0, 6.0], [156700.0, 2.0], [163100.0, 1.0], [41800.0, 10.0], [169500.0, 4.0], [43400.0, 12.0], [45000.0, 7.0], [175900.0, 3.0], [46600.0, 4.0], [48200.0, 10.0], [49800.0, 8.0], [53000.0, 3.0], [51400.0, 5.0], [54600.0, 2.0], [56200.0, 4.0], [57800.0, 6.0], [61000.0, 2.0], [59400.0, 1.0], [64200.0, 2.0], [67600.0, 6.0], [70800.0, 1.0], [77200.0, 2.0], [80400.0, 1.0], [83600.0, 3.0], [86800.0, 3.0], [93200.0, 2.0], [96400.0, 1.0], [99600.0, 5.0], [102800.0, 4.0], [106000.0, 2.0], [109200.0, 2.0], [118800.0, 2.0], [128400.0, 1.0], [136800.0, 1.0], [143200.0, 3.0], [149600.0, 1.0], [156000.0, 1.0], [162400.0, 3.0], [168800.0, 1.0], [175200.0, 3.0], [134500.0, 2.0], [153700.0, 2.0], [160100.0, 1.0], [166500.0, 3.0], [172900.0, 2.0], [67500.0, 4.0], [77100.0, 4.0], [80300.0, 1.0], [83500.0, 1.0], [93100.0, 7.0], [96300.0, 7.0], [99500.0, 3.0], [105900.0, 2.0], [102700.0, 7.0], [112300.0, 2.0], [118700.0, 3.0], [115500.0, 3.0], [145000.0, 1.0], [151400.0, 1.0], [157800.0, 1.0], [164200.0, 4.0], [170600.0, 3.0], [33300.0, 1.0], [136300.0, 1.0], [34900.0, 10.0], [36500.0, 8.0], [142700.0, 1.0], [38100.0, 11.0], [155500.0, 2.0], [39700.0, 11.0], [161900.0, 1.0], [41300.0, 5.0], [42900.0, 13.0], [168300.0, 2.0], [44500.0, 14.0], [174700.0, 4.0], [46100.0, 6.0], [47700.0, 6.0], [50900.0, 10.0], [49300.0, 9.0], [52500.0, 7.0], [54100.0, 5.0], [57300.0, 3.0], [55700.0, 4.0], [58900.0, 5.0], [60500.0, 4.0], [62100.0, 1.0], [65300.0, 3.0], [66600.0, 5.0], [69800.0, 4.0], [73000.0, 3.0], [76200.0, 6.0], [79400.0, 2.0], [85800.0, 3.0], [89000.0, 2.0], [92200.0, 2.0], [95400.0, 2.0], [101800.0, 8.0], [98600.0, 2.0], [105000.0, 3.0], [108200.0, 1.0], [114600.0, 1.0], [117800.0, 1.0], [134000.0, 1.0], [140400.0, 1.0], [146800.0, 1.0], [153200.0, 1.0], [159600.0, 2.0], [166000.0, 2.0], [172400.0, 2.0], [178800.0, 2.0], [138100.0, 3.0], [131700.0, 1.0], [144500.0, 1.0], [150900.0, 1.0], [157300.0, 2.0], [163700.0, 1.0], [170100.0, 1.0], [68900.0, 8.0], [65700.0, 3.0], [75300.0, 3.0], [78500.0, 3.0], [81700.0, 4.0], [84900.0, 2.0], [88100.0, 2.0], [91300.0, 1.0], [94500.0, 7.0], [97700.0, 2.0], [100900.0, 6.0], [104100.0, 3.0], [110500.0, 2.0], [107300.0, 2.0], [113700.0, 1.0], [116900.0, 1.0], [120100.0, 55.0], [129700.0, 1.0], [8500.0, 7.0], [8900.0, 4.0], [9300.0, 1.0], [9700.0, 3.0], [148600.0, 2.0], [10100.0, 6.0], [161400.0, 2.0], [10500.0, 5.0], [167800.0, 2.0], [10900.0, 3.0], [174200.0, 2.0], [11300.0, 3.0], [11700.0, 4.0], [12100.0, 7.0], [12500.0, 8.0], [13300.0, 3.0], [12900.0, 7.0], [13700.0, 3.0], [14100.0, 5.0], [14500.0, 9.0], [15300.0, 6.0], [14900.0, 7.0], [15700.0, 6.0], [16100.0, 5.0], [17000.0, 8.0], [17800.0, 6.0], [19400.0, 2.0], [18600.0, 5.0], [20200.0, 7.0], [21000.0, 6.0], [21800.0, 4.0], [22600.0, 8.0], [23400.0, 7.0], [24200.0, 3.0], [25000.0, 2.0], [25800.0, 6.0], [26600.0, 1.0], [27400.0, 3.0], [28200.0, 1.0], [29000.0, 7.0], [29800.0, 6.0], [30600.0, 4.0], [31400.0, 4.0], [32200.0, 4.0], [34000.0, 3.0], [35600.0, 4.0], [146300.0, 2.0], [37200.0, 6.0], [38800.0, 7.0], [152700.0, 1.0], [40400.0, 11.0], [42000.0, 8.0], [171900.0, 1.0], [165500.0, 1.0], [43600.0, 5.0], [178300.0, 3.0], [45200.0, 12.0], [46800.0, 6.0], [48400.0, 8.0], [50000.0, 9.0], [51600.0, 6.0], [53200.0, 2.0], [54800.0, 4.0], [56400.0, 3.0], [58000.0, 3.0], [61200.0, 1.0], [64400.0, 2.0], [68000.0, 4.0], [80800.0, 1.0], [87200.0, 1.0], [93600.0, 10.0], [90400.0, 1.0], [96800.0, 4.0], [100000.0, 7.0], [103200.0, 7.0], [106400.0, 4.0], [116000.0, 1.0], [119200.0, 2.0], [122400.0, 1.0], [136000.0, 1.0], [142400.0, 1.0], [155200.0, 2.0], [161600.0, 1.0], [168000.0, 2.0], [133700.0, 3.0], [152900.0, 2.0], [165700.0, 2.0], [172100.0, 2.0], [178500.0, 1.0], [67900.0, 2.0], [71100.0, 1.0], [77500.0, 2.0], [74300.0, 1.0], [80700.0, 2.0], [83900.0, 1.0], [87100.0, 3.0], [90300.0, 2.0], [93500.0, 5.0], [96700.0, 5.0], [99900.0, 6.0], [106300.0, 1.0], [103100.0, 4.0], [109500.0, 1.0], [115900.0, 1.0], [119100.0, 6.0], [125500.0, 1.0], [128700.0, 1.0], [163400.0, 1.0], [169800.0, 2.0], [33500.0, 6.0], [35100.0, 8.0], [36700.0, 7.0], [38300.0, 11.0], [154700.0, 1.0], [148300.0, 2.0], [39900.0, 13.0], [41500.0, 10.0], [167500.0, 3.0], [44700.0, 9.0], [43100.0, 5.0], [173900.0, 1.0], [46300.0, 12.0], [47900.0, 12.0], [49500.0, 11.0], [51100.0, 10.0], [52700.0, 3.0], [54300.0, 6.0], [55900.0, 6.0], [57500.0, 4.0], [60700.0, 1.0], [65500.0, 6.0], [67000.0, 7.0], [70200.0, 3.0], [73400.0, 2.0], [76600.0, 1.0], [79800.0, 1.0], [83000.0, 1.0], [86200.0, 2.0], [92600.0, 6.0], [95800.0, 4.0], [102200.0, 7.0], [99000.0, 4.0], [105400.0, 1.0], [108600.0, 2.0], [118200.0, 3.0], [115000.0, 2.0], [121400.0, 3.0], [124600.0, 1.0], [158800.0, 1.0], [171600.0, 2.0], [165200.0, 1.0], [162900.0, 1.0], [156500.0, 1.0], [169300.0, 4.0], [69300.0, 7.0], [72500.0, 5.0], [75700.0, 1.0], [78900.0, 3.0], [82100.0, 2.0], [85300.0, 1.0], [88500.0, 2.0], [91700.0, 1.0], [94900.0, 11.0], [98100.0, 7.0], [101300.0, 6.0], [104500.0, 4.0], [107700.0, 2.0], [114100.0, 4.0], [110900.0, 1.0], [117300.0, 2.0], [120500.0, 1.0], [126900.0, 2.0], [130100.0, 1.0], [154200.0, 2.0], [147800.0, 2.0], [167000.0, 5.0], [173400.0, 3.0], [17100.0, 3.0], [17900.0, 7.0], [18700.0, 8.0], [20300.0, 6.0], [19500.0, 6.0], [21100.0, 3.0], [21900.0, 1.0], [23500.0, 5.0], [22700.0, 2.0], [24300.0, 5.0], [25100.0, 7.0], [25900.0, 5.0], [26700.0, 6.0], [27500.0, 2.0], [28300.0, 6.0], [29100.0, 2.0], [30700.0, 5.0], [29900.0, 5.0], [31500.0, 7.0], [32300.0, 4.0], [34200.0, 6.0], [132700.0, 1.0], [35800.0, 9.0], [37400.0, 8.0], [151900.0, 2.0], [39000.0, 5.0], [40600.0, 7.0], [158300.0, 1.0], [42200.0, 7.0], [171100.0, 4.0], [164700.0, 1.0], [43800.0, 6.0], [45400.0, 11.0], [47000.0, 6.0], [48600.0, 7.0], [50200.0, 11.0], [51800.0, 4.0], [55000.0, 3.0], [53400.0, 2.0], [56600.0, 8.0], [58200.0, 1.0], [59800.0, 3.0], [63000.0, 1.0], [64600.0, 2.0], [68400.0, 4.0], [71600.0, 3.0], [74800.0, 2.0], [78000.0, 2.0], [81200.0, 1.0], [84400.0, 2.0], [87600.0, 3.0], [94000.0, 2.0], [100400.0, 9.0], [103600.0, 4.0], [106800.0, 2.0], [110000.0, 2.0], [116400.0, 4.0], [119600.0, 2.0], [129200.0, 1.0], [132000.0, 1.0], [151200.0, 1.0], [157600.0, 2.0], [164000.0, 1.0], [170400.0, 2.0], [142500.0, 1.0], [148900.0, 1.0], [161700.0, 2.0], [168100.0, 1.0], [174500.0, 2.0], [68300.0, 5.0], [71500.0, 2.0], [77900.0, 1.0], [93900.0, 4.0], [90700.0, 1.0], [97100.0, 3.0], [100300.0, 5.0], [103500.0, 8.0], [109900.0, 2.0], [106700.0, 2.0], [113100.0, 2.0], [116300.0, 2.0], [119500.0, 4.0], [125900.0, 2.0], [140200.0, 2.0], [159400.0, 1.0], [165800.0, 3.0], [172200.0, 3.0], [33700.0, 9.0], [137900.0, 1.0], [35300.0, 7.0], [38500.0, 18.0], [36900.0, 10.0], [40100.0, 10.0], [163500.0, 2.0], [157100.0, 1.0], [41700.0, 7.0], [169900.0, 2.0], [44900.0, 12.0], [43300.0, 7.0], [176300.0, 1.0], [46500.0, 13.0], [48100.0, 4.0], [49700.0, 5.0], [51300.0, 5.0], [54500.0, 8.0], [56100.0, 6.0], [57700.0, 7.0], [59300.0, 1.0], [64100.0, 1.0], [67400.0, 4.0], [70600.0, 3.0], [77000.0, 4.0], [73800.0, 4.0], [80200.0, 3.0], [86600.0, 1.0], [93000.0, 7.0], [96200.0, 6.0], [99400.0, 2.0], [105800.0, 2.0], [102600.0, 3.0], [109000.0, 2.0], [118600.0, 4.0], [115400.0, 1.0], [142000.0, 1.0], [154800.0, 2.0], [148400.0, 1.0], [161200.0, 1.0], [167600.0, 4.0], [174000.0, 1.0], [146100.0, 1.0], [152500.0, 1.0], [158900.0, 5.0], [171700.0, 1.0], [178100.0, 1.0], [4100.0, 12.0], [4300.0, 9.0], [66500.0, 8.0], [4500.0, 4.0], [69700.0, 3.0], [72900.0, 5.0], [4700.0, 5.0], [76100.0, 3.0], [5100.0, 3.0], [4900.0, 2.0], [79300.0, 2.0], [5300.0, 4.0], [85700.0, 2.0], [5500.0, 3.0], [5700.0, 5.0], [92100.0, 2.0], [5900.0, 1.0], [95300.0, 5.0], [6100.0, 1.0], [6300.0, 3.0], [98500.0, 2.0], [101700.0, 3.0], [6500.0, 4.0], [104900.0, 4.0], [6700.0, 4.0], [6900.0, 4.0], [108100.0, 2.0], [7100.0, 3.0], [114500.0, 3.0], [111300.0, 1.0], [7300.0, 3.0], [117700.0, 2.0], [7500.0, 7.0], [7900.0, 6.0], [7700.0, 5.0], [124100.0, 1.0], [130500.0, 1.0], [8200.0, 4.0], [8600.0, 2.0], [137400.0, 1.0], [9000.0, 3.0], [143800.0, 3.0], [9400.0, 3.0], [9800.0, 7.0], [10200.0, 4.0], [156600.0, 2.0], [10600.0, 2.0], [169400.0, 1.0], [11000.0, 3.0], [175800.0, 1.0], [11400.0, 3.0], [11800.0, 2.0], [12600.0, 6.0], [13000.0, 6.0], [13400.0, 5.0], [13800.0, 3.0], [14200.0, 9.0], [14600.0, 5.0], [15000.0, 5.0], [15800.0, 7.0], [15400.0, 7.0], [16200.0, 14.0], [17200.0, 2.0], [16400.0, 7.0], [18000.0, 6.0], [18800.0, 4.0], [19600.0, 15.0], [20400.0, 5.0], [21200.0, 5.0], [22000.0, 8.0], [22800.0, 2.0], [23600.0, 5.0], [24400.0, 4.0], [25200.0, 5.0], [26000.0, 2.0], [26800.0, 3.0], [27600.0, 3.0], [28400.0, 1.0], [29200.0, 5.0], [30000.0, 7.0], [30800.0, 4.0], [31600.0, 2.0], [32400.0, 5.0], [34400.0, 6.0], [32800.0, 3.0], [135100.0, 1.0], [36000.0, 13.0], [37600.0, 5.0], [154300.0, 1.0], [40800.0, 12.0], [39200.0, 6.0], [42400.0, 7.0], [167100.0, 2.0], [44000.0, 6.0], [179900.0, 1.0], [45600.0, 10.0], [48800.0, 6.0], [47200.0, 5.0], [50400.0, 11.0], [52000.0, 6.0], [53600.0, 6.0], [55200.0, 2.0], [56800.0, 6.0], [58400.0, 3.0], [60000.0, 4.0], [63200.0, 1.0], [61600.0, 2.0], [64800.0, 3.0], [65600.0, 2.0], [68800.0, 2.0], [72000.0, 2.0], [75200.0, 5.0], [78400.0, 5.0], [81600.0, 2.0], [84800.0, 2.0], [88000.0, 2.0], [91200.0, 2.0], [94400.0, 9.0], [97600.0, 3.0], [100800.0, 6.0], [104000.0, 6.0], [107200.0, 2.0], [110400.0, 2.0], [120000.0, 96.0], [123200.0, 1.0], [137600.0, 1.0], [144000.0, 1.0], [156800.0, 4.0], [163200.0, 4.0], [176000.0, 1.0], [141700.0, 1.0], [160900.0, 2.0], [167300.0, 3.0], [180100.0, 1.0], [173700.0, 5.0], [68700.0, 5.0], [71900.0, 2.0], [75100.0, 1.0], [78300.0, 2.0], [84700.0, 1.0], [87900.0, 2.0], [94300.0, 6.0], [97500.0, 6.0], [100700.0, 6.0], [103900.0, 8.0], [107100.0, 2.0], [110300.0, 1.0], [113500.0, 2.0], [116700.0, 4.0], [119900.0, 3.0], [126300.0, 2.0], [123100.0, 1.0], [133000.0, 1.0], [139400.0, 3.0], [152200.0, 1.0], [158600.0, 1.0], [165000.0, 3.0], [171400.0, 3.0], [33900.0, 9.0], [137100.0, 1.0], [35500.0, 13.0], [143500.0, 1.0], [37100.0, 8.0], [38700.0, 2.0], [40300.0, 8.0], [162700.0, 2.0], [156300.0, 1.0], [41900.0, 6.0], [169100.0, 1.0], [43500.0, 8.0], [175500.0, 1.0], [45100.0, 9.0], [46700.0, 10.0], [48300.0, 8.0], [49900.0, 5.0], [53100.0, 6.0], [51500.0, 4.0], [54700.0, 5.0], [56300.0, 4.0], [57900.0, 6.0], [61100.0, 1.0], [67800.0, 6.0], [71000.0, 2.0], [74200.0, 6.0], [77400.0, 4.0], [80600.0, 1.0], [83800.0, 2.0], [87000.0, 3.0], [90200.0, 4.0], [93400.0, 2.0], [96600.0, 8.0], [99800.0, 5.0], [103000.0, 6.0], [106200.0, 1.0], [112600.0, 1.0], [115800.0, 1.0], [125400.0, 2.0], [134800.0, 1.0], [141200.0, 1.0], [147600.0, 1.0], [160400.0, 5.0], [166800.0, 4.0], [173200.0, 4.0], [151700.0, 3.0], [158100.0, 1.0], [164500.0, 4.0], [170900.0, 3.0], [177300.0, 1.0], [66900.0, 7.0], [76500.0, 4.0], [79700.0, 1.0], [82900.0, 1.0], [89300.0, 1.0], [86100.0, 3.0], [92500.0, 3.0], [102100.0, 5.0], [98900.0, 4.0], [105300.0, 1.0], [108500.0, 1.0], [111700.0, 1.0], [118100.0, 1.0], [121300.0, 3.0], [124500.0, 1.0], [127700.0, 1.0], [162200.0, 3.0], [168600.0, 3.0], [175000.0, 4.0], [16500.0, 8.0], [17300.0, 4.0], [18100.0, 7.0], [18900.0, 12.0], [19700.0, 6.0], [20500.0, 6.0], [21300.0, 3.0], [22100.0, 6.0], [22900.0, 1.0], [24500.0, 3.0], [23700.0, 3.0], [25300.0, 5.0], [26100.0, 3.0], [26900.0, 7.0], [28500.0, 9.0], [27700.0, 4.0], [29300.0, 3.0], [30100.0, 7.0], [31700.0, 4.0], [30900.0, 3.0], [32500.0, 6.0], [33000.0, 6.0], [34600.0, 2.0], [36200.0, 5.0], [37800.0, 6.0], [153500.0, 2.0], [39400.0, 13.0], [159900.0, 2.0], [41000.0, 11.0], [42600.0, 17.0], [166300.0, 1.0], [44200.0, 9.0], [179100.0, 1.0], [45800.0, 10.0], [49000.0, 9.0], [47400.0, 5.0], [50600.0, 10.0], [52200.0, 3.0], [53800.0, 8.0], [55400.0, 4.0], [57000.0, 7.0], [58600.0, 7.0], [60200.0, 3.0], [63400.0, 2.0], [65000.0, 1.0], [69200.0, 2.0], [72400.0, 1.0], [75600.0, 5.0], [78800.0, 3.0], [82000.0, 1.0], [88400.0, 2.0], [91600.0, 2.0], [94800.0, 4.0], [98000.0, 3.0], [101200.0, 7.0], [104400.0, 4.0], [107600.0, 2.0], [114000.0, 1.0], [110800.0, 2.0], [117200.0, 3.0], [120400.0, 1.0], [123600.0, 2.0], [146400.0, 2.0], [172000.0, 2.0], [165600.0, 1.0], [150500.0, 1.0], [156900.0, 1.0], [163300.0, 3.0], [169700.0, 3.0], [65900.0, 4.0], [69100.0, 3.0], [72300.0, 4.0], [75500.0, 3.0], [81900.0, 4.0], [85100.0, 1.0], [91500.0, 3.0], [94700.0, 2.0], [97900.0, 6.0], [101100.0, 15.0], [104300.0, 5.0], [107500.0, 2.0], [110700.0, 1.0], [113900.0, 1.0], [117100.0, 4.0], [120300.0, 7.0], [126700.0, 2.0], [123500.0, 2.0], [141800.0, 3.0], [148200.0, 2.0], [161000.0, 1.0], [167400.0, 2.0], [173800.0, 1.0], [34100.0, 3.0], [133100.0, 2.0], [35700.0, 12.0], [139500.0, 1.0], [145900.0, 1.0], [38900.0, 8.0], [37300.0, 12.0], [152300.0, 1.0], [40500.0, 7.0], [158700.0, 2.0], [42100.0, 6.0], [165100.0, 2.0], [171500.0, 2.0], [43700.0, 12.0], [177900.0, 2.0], [45300.0, 11.0], [46900.0, 12.0], [48500.0, 10.0], [50100.0, 8.0], [51700.0, 6.0], [53300.0, 5.0], [54900.0, 12.0], [56500.0, 5.0], [58100.0, 4.0], [59700.0, 4.0], [61300.0, 1.0], [62900.0, 2.0], [64500.0, 3.0], [68200.0, 4.0], [71400.0, 2.0], [74600.0, 1.0], [77800.0, 4.0], [81000.0, 1.0], [84200.0, 2.0], [87400.0, 2.0], [93800.0, 4.0], [90600.0, 1.0], [97000.0, 5.0], [100200.0, 6.0], [103400.0, 4.0], [109800.0, 2.0], [106600.0, 3.0], [113000.0, 2.0], [116200.0, 1.0], [119400.0, 2.0], [125800.0, 1.0], [156400.0, 1.0], [162800.0, 3.0], [169200.0, 2.0], [175600.0, 2.0], [141300.0, 3.0], [154100.0, 2.0], [160500.0, 3.0], [166900.0, 4.0], [173300.0, 3.0], [179700.0, 1.0], [67300.0, 7.0], [70500.0, 1.0], [73700.0, 1.0], [76900.0, 2.0], [80100.0, 2.0], [83300.0, 1.0], [89700.0, 3.0], [86500.0, 2.0], [92900.0, 6.0], [96100.0, 4.0], [99300.0, 2.0], [102500.0, 5.0], [105700.0, 3.0], [108900.0, 2.0], [112100.0, 2.0], [118500.0, 2.0], [124900.0, 1.0], [128100.0, 2.0], [8300.0, 6.0], [8700.0, 1.0], [139000.0, 1.0], [9100.0, 11.0], [145400.0, 2.0], [9500.0, 4.0], [151800.0, 1.0], [9900.0, 8.0], [158200.0, 1.0], [10300.0, 3.0], [10700.0, 2.0], [164600.0, 4.0], [171000.0, 2.0], [11100.0, 4.0], [11500.0, 5.0], [11900.0, 3.0], [12700.0, 3.0], [12300.0, 3.0], [13100.0, 3.0], [13500.0, 4.0], [13900.0, 2.0], [14300.0, 6.0], [14700.0, 5.0], [15100.0, 5.0], [15500.0, 6.0], [16300.0, 7.0], [15900.0, 5.0], [16600.0, 5.0], [17400.0, 5.0], [18200.0, 5.0], [19000.0, 3.0], [19800.0, 7.0], [20600.0, 6.0], [21400.0, 9.0], [22200.0, 3.0], [23000.0, 5.0], [23800.0, 4.0], [25400.0, 4.0], [24600.0, 6.0], [26200.0, 4.0], [27000.0, 3.0], [28600.0, 3.0], [27800.0, 3.0], [29400.0, 4.0], [30200.0, 1.0], [31000.0, 6.0], [31800.0, 6.0], [32600.0, 2.0], [34800.0, 7.0], [33200.0, 4.0], [136700.0, 1.0], [36400.0, 7.0], [143100.0, 1.0], [38000.0, 9.0], [149500.0, 2.0], [39600.0, 8.0], [155900.0, 1.0], [162300.0, 2.0], [42800.0, 14.0], [41200.0, 4.0], [168700.0, 3.0], [44400.0, 9.0], [46000.0, 6.0], [47600.0, 13.0], [50800.0, 13.0], [49200.0, 4.0], [52400.0, 10.0], [54000.0, 7.0], [57200.0, 6.0], [55600.0, 4.0], [58800.0, 5.0], [60400.0, 2.0], [65200.0, 3.0], [63600.0, 2.0], [66400.0, 3.0], [69600.0, 1.0], [72800.0, 4.0], [76000.0, 2.0], [79200.0, 3.0], [82400.0, 1.0], [85600.0, 1.0], [88800.0, 2.0], [92000.0, 5.0], [95200.0, 6.0], [98400.0, 9.0], [101600.0, 7.0], [104800.0, 5.0], [108000.0, 1.0], [114400.0, 2.0], [111200.0, 1.0], [117600.0, 3.0], [139200.0, 1.0], [132800.0, 1.0], [145600.0, 1.0], [158400.0, 3.0], [164800.0, 2.0], [171200.0, 3.0], [177600.0, 2.0], [136900.0, 2.0], [149700.0, 1.0], [156100.0, 1.0], [162500.0, 4.0], [168900.0, 3.0], [175300.0, 1.0], [66300.0, 3.0], [69500.0, 3.0], [72700.0, 4.0], [75900.0, 4.0], [79100.0, 3.0], [88700.0, 1.0], [91900.0, 4.0], [95100.0, 7.0], [98300.0, 5.0], [101500.0, 8.0], [104700.0, 2.0], [107900.0, 1.0], [111100.0, 1.0], [117500.0, 4.0], [120700.0, 1.0], [130300.0, 2.0], [134600.0, 1.0], [147400.0, 1.0], [153800.0, 1.0], [160200.0, 1.0], [166600.0, 3.0], [173000.0, 5.0], [179400.0, 1.0], [34300.0, 7.0], [138700.0, 2.0], [35900.0, 5.0], [145100.0, 1.0], [37500.0, 5.0], [151500.0, 1.0], [40700.0, 11.0], [39100.0, 9.0], [157900.0, 1.0], [42300.0, 4.0], [164300.0, 2.0], [170700.0, 4.0], [43900.0, 12.0], [177100.0, 2.0], [45500.0, 8.0], [47100.0, 12.0], [48700.0, 15.0], [50300.0, 5.0], [51900.0, 6.0], [55100.0, 5.0], [53500.0, 6.0], [56700.0, 2.0], [58300.0, 5.0], [59900.0, 3.0], [63100.0, 2.0], [61500.0, 1.0], [64700.0, 1.0], [68600.0, 5.0], [71800.0, 1.0], [78200.0, 5.0], [81400.0, 1.0], [84600.0, 1.0], [87800.0, 3.0], [94200.0, 6.0], [97400.0, 6.0], [100600.0, 2.0], [103800.0, 4.0], [110200.0, 1.0], [107000.0, 2.0], [113400.0, 1.0], [116600.0, 3.0], [119800.0, 2.0], [136400.0, 3.0], [149200.0, 2.0], [155600.0, 1.0], [162000.0, 2.0], [168400.0, 3.0], [174800.0, 3.0], [140500.0, 1.0], [153300.0, 1.0], [166100.0, 2.0], [172500.0, 4.0], [178900.0, 1.0], [67700.0, 5.0], [70900.0, 3.0], [74100.0, 1.0], [80500.0, 1.0], [90100.0, 3.0], [86900.0, 1.0], [93300.0, 3.0], [96500.0, 3.0], [99700.0, 4.0], [102900.0, 6.0], [106100.0, 3.0], [112500.0, 1.0], [115700.0, 1.0], [118900.0, 2.0], [128500.0, 1.0], [163800.0, 2.0], [170200.0, 4.0], [16700.0, 4.0], [17500.0, 7.0], [18300.0, 2.0], [19100.0, 9.0], [19900.0, 5.0], [21500.0, 5.0], [20700.0, 4.0], [22300.0, 5.0], [23100.0, 5.0], [23900.0, 5.0], [24700.0, 2.0], [25500.0, 3.0], [26300.0, 8.0], [27100.0, 4.0], [27900.0, 5.0], [28700.0, 11.0], [29500.0, 5.0], [30300.0, 7.0], [31100.0, 2.0], [31900.0, 5.0], [32700.0, 6.0], [33400.0, 8.0], [135900.0, 1.0], [35000.0, 8.0], [36600.0, 3.0], [38200.0, 11.0], [39800.0, 10.0], [161500.0, 2.0], [43000.0, 7.0], [41400.0, 2.0], [167900.0, 2.0], [44600.0, 8.0], [174300.0, 3.0], [46200.0, 14.0], [47800.0, 8.0], [49400.0, 9.0], [51000.0, 7.0], [52600.0, 5.0], [54200.0, 2.0], [55800.0, 4.0], [57400.0, 3.0], [59000.0, 3.0], [60600.0, 4.0], [63800.0, 2.0], [65400.0, 5.0], [66800.0, 6.0], [70000.0, 5.0], [73200.0, 5.0], [76400.0, 1.0], [79600.0, 1.0], [86000.0, 2.0], [89200.0, 1.0], [92400.0, 1.0], [95600.0, 1.0], [102000.0, 5.0], [98800.0, 4.0], [105200.0, 5.0], [108400.0, 3.0], [118000.0, 1.0], [114800.0, 1.0]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 100, "maxX": 180100.0, "title": "Response Time Distribution"}},
        getOptions: function() {
            var granularity = this.data.result.granularity;
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    barWidth: this.data.result.granularity
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " responses for " + label + " were between " + xval + " and " + (xval + granularity) + " ms";
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimeDistribution"), prepareData(data.result.series, $("#choicesResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshResponseTimeDistribution() {
    var infos = responseTimeDistributionInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeDistribution");
        return;
    }
    if (isGraph($("#flotResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var syntheticResponseTimeDistributionInfos = {
        data: {"result": {"minY": 2.0, "minX": 0.0, "ticks": [[0, "Requests having \nresponse time <= 500ms"], [1, "Requests having \nresponse time > 500ms and <= 1,500ms"], [2, "Requests having \nresponse time > 1,500ms"], [3, "Requests in error"]], "maxY": 5767.0, "series": [{"data": [[0.0, 2.0]], "color": "#9ACD32", "isOverall": false, "label": "Requests having \nresponse time <= 500ms", "isController": false}, {"data": [[1.0, 73.0]], "color": "yellow", "isOverall": false, "label": "Requests having \nresponse time > 500ms and <= 1,500ms", "isController": false}, {"data": [[2.0, 5767.0]], "color": "orange", "isOverall": false, "label": "Requests having \nresponse time > 1,500ms", "isController": false}, {"data": [[3.0, 598.0]], "color": "#FF6347", "isOverall": false, "label": "Requests in error", "isController": false}], "supportsControllersDiscrimination": false, "maxX": 3.0, "title": "Synthetic Response Times Distribution"}},
        getOptions: function() {
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendSyntheticResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times ranges",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                    tickLength:0,
                    min:-0.5,
                    max:3.5
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    align: "center",
                    barWidth: 0.25,
                    fill:.75
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " " + label;
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            options.xaxis.ticks = data.result.ticks;
            $.plot($("#flotSyntheticResponseTimeDistribution"), prepareData(data.result.series, $("#choicesSyntheticResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshSyntheticResponseTimeDistribution() {
    var infos = syntheticResponseTimeDistributionInfos;
    prepareSeries(infos.data, true);
    if (isGraph($("#flotSyntheticResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerSyntheticResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var activeThreadsOverTimeInfos = {
        data: {"result": {"minY": 148.53378378378372, "minX": 1.69659996E12, "maxY": 1349.0144167758838, "series": [{"data": [[1.69660044E12, 148.53378378378372], [1.69660008E12, 873.8135338345863], [1.69660014E12, 1196.8192090395478], [1.69660026E12, 1122.3140495867751], [1.69659996E12, 237.30578512396698], [1.6966002E12, 1158.5972738537778], [1.69660002E12, 930.0777202072546], [1.69660038E12, 757.0466883821942], [1.69660032E12, 1349.0144167758838]], "isOverall": false, "label": "jp@gc - Ultimate Thread Group", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69660044E12, "title": "Active Threads Over Time"}},
        getOptions: function() {
            return {
                series: {
                    stack: true,
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 6,
                    show: true,
                    container: '#legendActiveThreadsOverTime'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                selection: {
                    mode: 'xy'
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : At %x there were %y active threads"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesActiveThreadsOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotActiveThreadsOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewActiveThreadsOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Active Threads Over Time
function refreshActiveThreadsOverTime(fixTimestamps) {
    var infos = activeThreadsOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotActiveThreadsOverTime"))) {
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesActiveThreadsOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotActiveThreadsOverTime", "#overviewActiveThreadsOverTime");
        $('#footerActiveThreadsOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var timeVsThreadsInfos = {
        data: {"result": {"minY": 596.2, "minX": 1.0, "maxY": 180026.0, "series": [{"data": [[2.0, 130776.0], [3.0, 142930.0], [4.0, 130529.0], [6.0, 137706.0], [7.0, 145659.0], [8.0, 145118.0], [9.0, 145442.0], [10.0, 146460.0], [11.0, 148459.0], [12.0, 145278.0], [13.0, 145984.0], [14.0, 146885.0], [15.0, 151353.0], [16.0, 129789.0], [17.0, 144417.0], [18.0, 149272.0], [19.0, 147496.0], [20.0, 143823.0], [21.0, 143252.0], [22.0, 148049.0], [23.0, 146454.0], [24.0, 146303.0], [25.0, 151368.0], [26.0, 143871.0], [27.0, 147508.0], [28.0, 148253.0], [29.0, 148970.0], [30.0, 127723.0], [31.0, 148358.0], [32.0, 147881.0], [35.0, 151672.5], [34.0, 149618.0], [37.0, 137902.0], [39.0, 129281.0], [38.0, 153514.0], [41.0, 33893.25], [40.0, 142407.0], [42.0, 139352.0], [44.0, 596.2], [45.0, 110751.5], [46.0, 75532.5], [47.0, 156514.0], [48.0, 67966.5], [49.0, 148317.0], [50.0, 39357.0], [51.0, 154477.0], [53.0, 154282.0], [52.0, 151448.0], [54.0, 76614.5], [55.0, 78173.0], [57.0, 76460.0], [56.0, 151776.0], [58.0, 29319.4], [59.0, 157510.0], [61.0, 36779.75], [60.0, 152785.0], [62.0, 79642.0], [63.0, 157679.0], [64.0, 43558.333333333336], [65.0, 920.5], [67.0, 71350.0], [66.0, 138856.5], [68.0, 32015.0], [69.0, 71009.5], [71.0, 44859.333333333336], [70.0, 142177.0], [74.0, 81808.5], [75.0, 146140.0], [73.0, 153882.0], [72.0, 157833.0], [78.0, 37160.25], [79.0, 72530.0], [77.0, 156343.0], [76.0, 156728.0], [80.0, 72350.5], [81.0, 50621.0], [83.0, 148615.0], [82.0, 160412.0], [84.0, 55450.0], [85.0, 74762.0], [87.0, 80491.0], [86.0, 162813.0], [88.0, 50164.0], [90.0, 80878.5], [91.0, 51536.666666666664], [89.0, 161569.0], [94.0, 24849.85714285714], [95.0, 152215.0], [93.0, 152683.0], [92.0, 164628.0], [97.0, 76293.0], [98.0, 31389.6], [99.0, 162559.0], [96.0, 107371.0], [100.0, 52388.666666666664], [101.0, 83813.0], [102.0, 38427.0], [103.0, 153220.0], [104.0, 35803.0], [105.0, 82523.5], [107.0, 1601.0], [106.0, 167604.0], [108.0, 46391.42857142857], [111.0, 53569.666666666664], [110.0, 154903.0], [109.0, 156853.0], [113.0, 55217.333333333336], [114.0, 80804.5], [115.0, 157130.0], [112.0, 159997.0], [117.0, 41509.0], [118.0, 27833.5], [119.0, 157584.0], [116.0, 167091.0], [123.0, 107178.0], [122.0, 153335.0], [121.0, 156676.0], [120.0, 158962.0], [125.0, 79630.5], [127.0, 80900.0], [124.0, 164525.0], [131.0, 56248.0], [135.0, 55139.5], [134.0, 157773.0], [133.0, 102667.0], [132.0, 159409.0], [130.0, 162477.0], [129.0, 165527.0], [128.0, 160414.0], [137.0, 33785.0], [138.0, 35041.333333333336], [143.0, 164702.0], [142.0, 106770.0], [141.0, 156859.0], [140.0, 112675.0], [139.0, 103319.0], [136.0, 163105.0], [144.0, 38253.666666666664], [145.0, 42180.75], [147.0, 36641.666666666664], [151.0, 83576.0], [150.0, 109813.0], [149.0, 164849.0], [148.0, 107695.0], [146.0, 167021.0], [152.0, 52734.0], [154.0, 43244.25], [157.0, 57137.0], [158.0, 37798.333333333336], [159.0, 163949.0], [156.0, 116749.0], [155.0, 166407.0], [153.0, 106994.0], [160.0, 55953.5], [161.0, 37349.0], [164.0, 59082.0], [167.0, 56602.666666666664], [166.0, 105613.0], [165.0, 103923.0], [163.0, 115769.0], [162.0, 105673.0], [168.0, 53384.5], [171.0, 21182.0], [172.0, 37318.333333333336], [174.0, 41256.333333333336], [175.0, 37684.0], [173.0, 110085.0], [170.0, 111513.0], [169.0, 119964.0], [177.0, 56787.0], [178.0, 28360.75], [179.0, 55676.0], [180.0, 61501.0], [181.0, 58292.5], [182.0, 41688.0], [183.0, 112305.0], [176.0, 112068.0], [184.0, 60535.0], [185.0, 37615.333333333336], [187.0, 61247.5], [188.0, 25951.6], [189.0, 56510.5], [190.0, 41647.0], [191.0, 115560.0], [186.0, 110485.0], [195.0, 58253.0], [197.0, 58168.0], [198.0, 25963.6], [199.0, 114801.0], [196.0, 110815.0], [194.0, 117189.0], [193.0, 119590.0], [192.0, 120119.0], [200.0, 59635.5], [201.0, 22553.666666666668], [202.0, 61421.5], [204.0, 19567.285714285714], [205.0, 61591.5], [207.0, 32123.25], [206.0, 120079.0], [203.0, 120091.0], [208.0, 61533.5], [209.0, 61526.5], [210.0, 61819.0], [211.0, 26648.6], [213.0, 62104.5], [214.0, 61960.0], [215.0, 120118.0], [212.0, 120110.0], [217.0, 61538.5], [218.0, 42719.333333333336], [219.0, 42054.666666666664], [220.0, 61935.5], [221.0, 61969.0], [222.0, 61806.5], [223.0, 120206.0], [216.0, 120098.0], [224.0, 38606.6], [225.0, 61853.0], [227.0, 62064.5], [228.0, 62111.5], [230.0, 41911.666666666664], [231.0, 26697.6], [229.0, 120359.0], [226.0, 120164.0], [232.0, 32118.25], [235.0, 61879.666666666664], [237.0, 42318.666666666664], [238.0, 28836.571428571428], [239.0, 32384.25], [236.0, 120088.0], [234.0, 120095.0], [233.0, 120101.0], [241.0, 41972.666666666664], [242.0, 61557.0], [245.0, 61361.5], [247.0, 32309.0], [246.0, 120070.0], [244.0, 180021.0], [243.0, 180013.0], [240.0, 120152.0], [248.0, 61398.5], [249.0, 32079.75], [250.0, 62103.5], [251.0, 22607.5], [252.0, 38349.0], [255.0, 61262.0], [254.0, 120194.0], [253.0, 120182.0], [258.0, 61577.5], [257.0, 41919.0], [256.0, 120307.0], [259.0, 91691.0], [268.0, 32481.5], [270.0, 15710.666666666666], [269.0, 120075.0], [271.0, 120251.0], [260.0, 61603.5], [261.0, 17694.125], [262.0, 31948.5], [263.0, 180017.0], [264.0, 8097.235294117647], [265.0, 13404.0], [266.0, 11616.272727272728], [267.0, 26435.8], [284.0, 22490.166666666668], [274.0, 47336.0], [275.0, 61215.5], [277.0, 38030.8], [276.0, 120092.0], [278.0, 42884.666666666664], [279.0, 120080.0], [273.0, 120122.0], [272.0, 120129.0], [280.0, 41510.333333333336], [281.0, 26715.6], [283.0, 120393.0], [282.0, 120365.0], [285.0, 61367.5], [287.0, 62173.5], [286.0, 180006.0], [291.0, 62487.0], [289.0, 60160.5], [288.0, 4999.107142857143], [290.0, 24873.6], [293.0, 62557.5], [292.0, 120125.0], [294.0, 120127.0], [295.0, 91819.5], [300.0, 63135.666666666664], [301.0, 120130.0], [303.0, 120129.0], [297.0, 180008.0], [296.0, 120103.0], [299.0, 120122.0], [298.0, 120138.0], [302.0, 180023.0], [317.0, 92093.5], [304.0, 62547.5], [307.0, 62233.0], [306.0, 120093.0], [305.0, 120080.0], [316.0, 120109.0], [310.0, 62138.5], [309.0, 120116.0], [308.0, 120116.0], [311.0, 120075.0], [312.0, 62107.0], [313.0, 92008.5], [314.0, 33728.25], [315.0, 92724.5], [318.0, 62769.5], [319.0, 180023.0], [333.0, 63271.0], [320.0, 62642.0], [321.0, 62749.0], [322.0, 180018.0], [332.0, 122963.0], [323.0, 180026.0], [327.0, 4165.0], [326.0, 120523.0], [325.0, 120145.0], [324.0, 120165.0], [328.0, 62917.0], [330.0, 62682.0], [329.0, 121315.0], [331.0, 62735.5], [334.0, 65003.5], [335.0, 43959.0], [350.0, 28353.0], [337.0, 63246.5], [338.0, 33805.5], [339.0, 121494.0], [349.0, 124905.0], [348.0, 124760.0], [340.0, 63646.5], [341.0, 4093.0], [343.0, 63993.5], [336.0, 122486.0], [342.0, 125242.5], [344.0, 63402.0], [345.0, 24204.333333333332], [347.0, 24322.833333333336], [346.0, 123595.0], [351.0, 28610.4], [364.0, 41454.5], [354.0, 18154.8], [353.0, 64534.5], [352.0, 126926.0], [355.0, 65479.5], [357.0, 63501.0], [356.0, 80684.0], [358.0, 36021.5], [361.0, 20634.666666666664], [362.0, 63661.5], [363.0, 39608.0], [367.0, 69103.0], [366.0, 65490.0], [365.0, 128183.0], [382.0, 86091.0], [380.0, 45387.666666666664], [383.0, 125912.0], [381.0, 125593.0], [379.0, 98920.5], [377.0, 125430.0], [376.0, 72999.0], [375.0, 65913.0], [369.0, 99622.0], [371.0, 74505.0], [370.0, 128516.0], [374.0, 76726.0], [373.0, 72307.0], [372.0, 72988.0], [397.0, 6578.0], [387.0, 26013.666666666668], [394.0, 53475.5], [399.0, 69867.0], [398.0, 113454.0], [396.0, 91827.0], [393.0, 98911.0], [392.0, 89787.0], [391.0, 126779.0], [384.0, 128179.0], [386.0, 66525.0], [385.0, 64883.0], [390.0, 87110.0], [389.0, 68395.0], [388.0, 86982.0], [413.0, 66281.0], [400.0, 37352.66666666667], [401.0, 53049.0], [402.0, 98159.0], [405.0, 52721.0], [404.0, 98026.0], [407.0, 93102.0], [406.0, 99511.0], [415.0, 74223.0], [414.0, 65403.0], [412.0, 126999.0], [403.0, 126614.0], [411.0, 97818.0], [410.0, 99795.0], [409.0, 94574.0], [408.0, 94387.0], [431.0, 72734.0], [423.0, 41469.0], [416.0, 101434.0], [419.0, 100168.0], [418.0, 99095.0], [422.0, 126321.0], [421.0, 101164.0], [420.0, 98659.0], [425.0, 6541.0], [428.0, 44585.5], [430.0, 73824.0], [429.0, 102230.0], [427.0, 75726.0], [426.0, 78176.0], [424.0, 79207.0], [444.0, 22955.5], [434.0, 53868.0], [435.0, 81376.0], [439.0, 101335.0], [433.0, 85049.5], [437.0, 41710.5], [436.0, 88487.0], [438.0, 48052.0], [440.0, 32833.66666666667], [441.0, 81963.0], [447.0, 6898.0], [446.0, 68309.0], [445.0, 68055.0], [443.0, 84510.0], [442.0, 64525.0], [463.0, 101337.0], [455.0, 44161.5], [454.0, 96860.0], [453.0, 79090.0], [452.0, 81695.0], [457.0, 37145.33333333333], [462.0, 89574.0], [461.0, 180014.0], [460.0, 79310.0], [451.0, 83654.0], [450.0, 82703.0], [449.0, 180014.0], [448.0, 86141.5], [459.0, 93007.0], [458.0, 83595.0], [456.0, 90987.0], [477.0, 52573.5], [465.0, 55830.0], [467.0, 63151.666666666664], [470.0, 51835.0], [469.0, 86106.0], [468.0, 83657.0], [471.0, 34568.66666666667], [464.0, 99432.0], [479.0, 96968.0], [478.0, 98870.0], [476.0, 97948.0], [475.0, 97452.0], [474.0, 96389.0], [473.0, 98894.0], [472.0, 99133.0], [494.0, 54429.33333333333], [480.0, 43545.0], [481.0, 102454.0], [483.0, 79163.0], [482.0, 74061.0], [487.0, 81772.5], [486.0, 79032.0], [485.0, 77590.0], [484.0, 120096.5], [490.0, 44212.25], [495.0, 60502.0], [493.0, 109694.5], [492.0, 77978.0], [491.0, 79575.5], [489.0, 120085.5], [488.0, 80149.66666666666], [510.0, 58914.0], [503.0, 58906.5], [502.0, 72293.0], [497.0, 110517.0], [496.0, 141182.0], [499.0, 85921.5], [498.0, 78683.5], [501.0, 80680.0], [500.0, 84188.5], [511.0, 94308.0], [509.0, 84168.5], [508.0, 83699.0], [507.0, 84078.0], [506.0, 81811.5], [505.0, 85918.5], [504.0, 81389.0], [541.0, 57891.66666666667], [521.0, 59658.66666666667], [522.0, 103001.0], [520.0, 113536.0], [524.0, 81956.0], [523.0, 76379.0], [525.0, 64394.5], [531.0, 47771.0], [530.0, 84685.5], [529.0, 82475.5], [528.0, 85806.0], [533.0, 88190.5], [532.0, 80785.0], [535.0, 71610.5], [534.0, 83845.0], [543.0, 85301.66666666666], [542.0, 82431.0], [540.0, 56295.25], [539.0, 83395.0], [538.0, 79603.0], [537.0, 56267.33333333333], [536.0, 82307.0], [519.0, 84416.0], [518.0, 83493.5], [517.0, 90814.33333333333], [516.0, 70502.0], [515.0, 121067.5], [514.0, 84520.0], [513.0, 81876.5], [512.0, 57081.0], [527.0, 109512.0], [526.0, 85197.0], [568.0, 55429.5], [547.0, 61136.66666666667], [548.0, 60500.0], [549.0, 97386.0], [551.0, 83176.5], [550.0, 77519.33333333333], [554.0, 60844.0], [553.0, 100812.0], [552.0, 100000.0], [556.0, 99220.66666666667], [555.0, 107710.0], [557.0, 60251.0], [558.0, 62276.33333333333], [559.0, 61917.0], [546.0, 85391.5], [545.0, 81754.5], [544.0, 55227.33333333333], [561.0, 59200.66666666667], [564.0, 60704.33333333333], [563.0, 122562.0], [562.0, 83360.5], [565.0, 86700.0], [567.0, 74322.0], [566.0, 84860.5], [570.0, 60610.66666666667], [569.0, 79463.0], [571.0, 58912.66666666667], [574.0, 80156.5], [572.0, 85380.0], [573.0, 180011.0], [575.0, 84193.5], [560.0, 90622.33333333333], [601.0, 63441.66666666667], [581.0, 53758.0], [584.0, 48836.75], [585.0, 82283.5], [587.0, 82184.0], [586.0, 82656.0], [589.0, 113226.0], [588.0, 125111.5], [591.0, 83857.5], [576.0, 70237.0], [578.0, 88023.5], [577.0, 93596.33333333333], [580.0, 95298.66666666667], [579.0, 68613.0], [590.0, 87525.0], [593.0, 10570.0], [592.0, 93159.0], [594.0, 52808.99999999999], [597.0, 86782.66666666666], [596.0, 35598.0], [595.0, 118897.5], [599.0, 60777.66666666667], [598.0, 86469.5], [600.0, 81906.33333333334], [583.0, 81315.5], [582.0, 78723.33333333333], [607.0, 81435.0], [606.0, 87245.0], [605.0, 99496.66666666666], [604.0, 87864.0], [603.0, 85038.5], [602.0, 57984.33333333333], [634.0, 86920.0], [638.0, 60974.33333333333], [614.0, 62767.33333333333], [611.0, 61541.0], [610.0, 87001.5], [609.0, 115734.5], [608.0, 88882.0], [613.0, 82356.0], [612.0, 86127.5], [615.0, 48565.25], [633.0, 80174.5], [632.0, 90884.0], [635.0, 84304.0], [637.0, 59567.0], [636.0, 114380.5], [617.0, 61475.0], [616.0, 119503.5], [618.0, 84014.0], [620.0, 84096.0], [619.0, 89168.0], [622.0, 65331.0], [621.0, 87432.0], [623.0, 66251.0], [624.0, 98144.25], [625.0, 54094.6], [626.0, 87046.5], [627.0, 111115.0], [628.0, 56169.666666666664], [631.0, 87037.5], [630.0, 90660.0], [629.0, 90544.5], [639.0, 125015.0], [665.0, 64723.5], [654.0, 48674.25], [648.0, 61557.0], [650.0, 85732.0], [649.0, 59111.0], [651.0, 61766.0], [653.0, 61951.66666666667], [652.0, 90273.5], [655.0, 39898.2], [641.0, 69595.0], [640.0, 85588.0], [643.0, 86854.5], [642.0, 85707.66666666667], [645.0, 94747.33333333333], [644.0, 36403.5], [647.0, 102324.66666666666], [664.0, 101586.0], [646.0, 88633.25], [666.0, 72143.0], [667.0, 62468.33333333333], [668.0, 58014.66666666667], [669.0, 90142.0], [671.0, 81553.5], [656.0, 82739.0], [658.0, 120776.5], [657.0, 113880.5], [660.0, 88014.5], [659.0, 80453.0], [662.0, 84924.0], [663.0, 171400.0], [661.0, 80665.5], [670.0, 81202.5], [679.0, 87533.66666666667], [700.0, 36117.25], [681.0, 38047.0], [680.0, 67848.0], [682.0, 85959.0], [683.0, 63002.0], [685.0, 38288.666666666664], [684.0, 123911.5], [697.0, 80674.33333333333], [696.0, 94373.0], [678.0, 66691.0], [677.0, 82437.5], [676.0, 87616.5], [675.0, 123680.5], [674.0, 83668.0], [673.0, 56428.5], [672.0, 86551.5], [687.0, 104619.0], [686.0, 84910.0], [699.0, 56750.0], [698.0, 86090.5], [688.0, 62583.75], [691.0, 62843.33333333333], [690.0, 37245.4], [689.0, 89007.0], [693.0, 58939.66666666667], [692.0, 122637.0], [694.0, 79449.75], [695.0, 80063.5], [701.0, 61325.66666666667], [702.0, 60753.66666666667], [703.0, 119451.5], [730.0, 117822.5], [734.0, 36299.5], [708.0, 86513.66666666666], [711.0, 57239.66666666667], [710.0, 53516.5], [709.0, 59416.5], [729.0, 55986.5], [728.0, 81834.0], [731.0, 58168.0], [715.0, 46886.5], [714.0, 97118.66666666667], [713.0, 55605.0], [712.0, 123373.5], [717.0, 54997.0], [716.0, 79765.33333333333], [719.0, 80465.0], [705.0, 58186.0], [704.0, 122772.0], [707.0, 116675.0], [706.0, 118199.0], [718.0, 137519.66666666666], [720.0, 54589.0], [721.0, 64969.75], [723.0, 58093.0], [722.0, 75126.5], [725.0, 97433.5], [724.0, 58566.33333333333], [727.0, 50901.0], [726.0, 118951.5], [735.0, 53941.666666666664], [733.0, 52166.0], [732.0, 56128.0], [761.0, 84505.66666666666], [738.0, 57194.0], [737.0, 21519.0], [736.0, 109447.5], [740.0, 117246.5], [739.0, 52785.33333333333], [741.0, 57514.8], [743.0, 34628.5], [742.0, 122273.0], [760.0, 79367.5], [751.0, 33314.0], [750.0, 61597.0], [749.0, 118977.0], [748.0, 81066.5], [747.0, 56507.5], [746.0, 52392.0], [745.0, 51149.0], [744.0, 71803.66666666667], [757.0, 42638.333333333336], [756.0, 46516.0], [755.0, 118883.5], [754.0, 74979.33333333334], [753.0, 78417.5], [752.0, 97668.33333333334], [759.0, 57596.0], [758.0, 77599.5], [764.0, 83956.33333333334], [763.0, 55220.5], [762.0, 56308.5], [765.0, 62526.5], [767.0, 107053.0], [766.0, 121558.5], [797.0, 98577.66666666667], [771.0, 36406.57142857143], [781.0, 51861.666666666664], [780.0, 59843.0], [779.0, 112916.0], [778.0, 126013.375], [777.0, 136588.0], [776.0, 126768.25], [783.0, 136118.33333333334], [768.0, 92082.66666666667], [770.0, 136488.66666666666], [769.0, 105516.0], [782.0, 138020.33333333334], [787.0, 78380.71428571428], [786.0, 122932.5], [785.0, 89345.66666666667], [784.0, 45733.666666666664], [791.0, 82684.77777777778], [790.0, 103541.33333333334], [789.0, 148860.33333333334], [788.0, 90585.66666666667], [798.0, 56335.857142857145], [799.0, 135823.0], [796.0, 76110.83333333333], [795.0, 88975.75], [794.0, 103094.2222222222], [793.0, 102570.63636363637], [792.0, 75081.36363636365], [775.0, 60174.25], [774.0, 54490.0], [773.0, 102825.0], [772.0, 64658.666666666664], [805.0, 66471.66666666667], [803.0, 61939.33333333333], [800.0, 84848.28571428571], [802.0, 92212.5], [801.0, 75489.5], [815.0, 76355.6], [814.0, 85315.0], [813.0, 111579.0], [812.0, 71168.8], [811.0, 65806.0], [804.0, 89389.66666666667], [807.0, 40838.4], [806.0, 120977.0], [824.0, 48876.8], [825.0, 110651.0], [827.0, 29759.2], [826.0, 76863.5], [808.0, 109177.0], [809.0, 100013.0], [810.0, 63159.0], [828.0, 65517.25], [829.0, 56096.4], [830.0, 140223.00000000003], [831.0, 70835.08333333334], [822.0, 43679.0], [823.0, 113292.0], [821.0, 74057.0], [820.0, 127600.4], [819.0, 54512.5], [818.0, 88623.0], [817.0, 71194.75], [816.0, 76349.4], [856.0, 20167.666666666664], [860.0, 87595.5], [842.0, 67633.4], [841.0, 38901.5], [840.0, 108858.5], [844.0, 48729.66666666667], [843.0, 109207.0], [846.0, 95410.8], [845.0, 49487.5], [847.0, 37754.8], [852.0, 36989.25], [851.0, 97505.5], [850.0, 72875.0], [849.0, 62355.0], [848.0, 81695.25], [853.0, 102376.25], [854.0, 79166.75], [855.0, 39429.5], [858.0, 46507.142857142855], [857.0, 80441.8], [838.0, 86650.2], [837.0, 128995.0], [839.0, 114753.0], [836.0, 38991.75], [834.0, 31109.333333333332], [835.0, 76055.66666666666], [833.0, 124618.33333333333], [832.0, 71368.5], [859.0, 91513.66666666666], [861.0, 39700.25], [862.0, 137185.0], [863.0, 38449.8], [870.0, 46726.83333333333], [865.0, 49983.4], [864.0, 85175.2], [866.0, 119790.66666666667], [867.0, 71191.4], [868.0, 75174.0], [869.0, 74860.66666666666], [871.0, 53027.8], [888.0, 79572.4], [894.0, 85300.8], [893.0, 96405.2], [892.0, 79273.0], [891.0, 56362.8], [890.0, 101587.6], [889.0, 103307.44444444445], [895.0, 79029.8], [877.0, 80824.33333333334], [876.0, 59238.333333333336], [878.0, 170418.5], [875.0, 92561.75], [874.0, 33050.0], [873.0, 50407.6], [872.0, 70332.0], [879.0, 43591.0], [880.0, 74465.0], [884.0, 81461.83333333334], [883.0, 72464.0], [882.0, 80316.75], [881.0, 56374.857142857145], [885.0, 111490.4], [887.0, 49204.8], [886.0, 61700.5], [897.0, 105762.85714285714], [905.0, 100062.14285714286], [904.0, 105294.81818181818], [906.0, 82641.66666666666], [911.0, 89416.33333333333], [896.0, 82674.14285714286], [910.0, 79978.5], [909.0, 99140.28571428571], [908.0, 75296.85714285714], [907.0, 56331.71428571428], [917.0, 58951.75], [918.0, 93741.6], [919.0, 90896.33333333334], [920.0, 104921.5], [903.0, 85777.625], [902.0, 121519.0], [901.0, 115754.22222222222], [900.0, 75485.16666666667], [899.0, 103764.125], [898.0, 56833.333333333336], [921.0, 92193.5], [924.0, 96178.0], [923.0, 122352.33333333334], [922.0, 86975.57142857142], [926.0, 79761.75], [912.0, 74623.25], [927.0, 59720.25], [914.0, 151711.4], [913.0, 96519.66666666666], [916.0, 95671.0], [915.0, 90035.0], [925.0, 85819.2], [955.0, 84201.84615384614], [959.0, 92264.62499999999], [931.0, 84596.57142857143], [930.0, 93247.2], [929.0, 82587.0], [928.0, 117453.375], [933.0, 135294.33333333334], [932.0, 134645.25], [943.0, 95687.6], [942.0, 87949.28571428572], [941.0, 122505.00000000001], [940.0, 116926.6], [939.0, 85607.0], [938.0, 45230.8], [937.0, 106359.99999999999], [936.0, 90199.22222222222], [934.0, 85820.33333333334], [944.0, 91230.88888888889], [946.0, 113510.0], [945.0, 101064.6], [947.0, 90423.64285714286], [948.0, 73380.33333333333], [949.0, 99563.6], [951.0, 92680.66666666666], [950.0, 79738.2], [954.0, 80480.50000000001], [953.0, 98094.0], [952.0, 113266.16666666666], [935.0, 153828.4], [956.0, 103375.0], [958.0, 135839.33333333334], [957.0, 119796.88888888889], [987.0, 66257.38461538461], [964.0, 106383.16666666666], [973.0, 77914.70000000001], [972.0, 59118.25], [971.0, 99090.0], [970.0, 75941.0], [969.0, 72155.4], [968.0, 118874.25], [975.0, 83271.99999999999], [960.0, 71052.88888888889], [961.0, 114626.92307692308], [963.0, 81817.42857142858], [962.0, 93393.5], [974.0, 84334.14285714286], [977.0, 70835.83333333334], [980.0, 47392.375], [979.0, 52437.571428571435], [978.0, 68716.8], [981.0, 121232.2], [983.0, 68969.11111111111], [982.0, 89196.92307692309], [984.0, 83385.30769230769], [967.0, 129260.66666666666], [966.0, 106600.0], [965.0, 120638.2], [986.0, 64442.454545454544], [985.0, 140684.0], [991.0, 75047.6], [976.0, 125042.2], [990.0, 94083.5], [989.0, 76230.09090909091], [988.0, 129683.49999999999], [999.0, 76687.16666666667], [994.0, 77015.11111111111], [997.0, 61689.375], [1010.0, 81475.66666666667], [1017.0, 97710.14285714286], [1016.0, 113475.5], [1019.0, 126506.75], [1018.0, 132729.2], [1021.0, 96063.71428571429], [1020.0, 100446.4], [1022.0, 107258.54545454546], [1023.0, 74763.90909090909], [1008.0, 83169.0], [1009.0, 132208.0], [1011.0, 60271.125], [1013.0, 115059.75], [1012.0, 89208.66666666667], [1015.0, 125315.75], [1014.0, 131372.0], [1000.0, 33358.8174386921], [1002.0, 91025.25], [1001.0, 139062.66666666666], [1003.0, 81165.75], [1005.0, 88987.0], [1004.0, 84959.33333333334], [1007.0, 86154.0], [1006.0, 138034.5], [998.0, 96764.37500000001], [996.0, 92909.87500000001], [995.0, 64895.923076923085], [993.0, 96720.125], [992.0, 88849.0], [1080.0, 107691.42857142857], [1030.0, 69888.5], [1050.0, 79930.8], [1048.0, 117866.0], [1046.0, 118866.8], [1044.0, 111379.75], [1042.0, 60992.75], [1040.0, 98089.66666666667], [1052.0, 131463.4], [1054.0, 116281.25], [1024.0, 116540.85714285714], [1028.0, 110254.4], [1026.0, 115825.8], [1064.0, 110349.8], [1062.0, 129854.0], [1060.0, 128454.33333333333], [1058.0, 80274.0], [1056.0, 124394.25], [1066.0, 149428.0], [1070.0, 166072.66666666666], [1068.0, 105479.00000000001], [1086.0, 92618.0], [1082.0, 93524.0], [1084.0, 108698.5], [1078.0, 130173.25], [1076.0, 88796.0], [1074.0, 122888.88888888889], [1072.0, 92897.33333333334], [1038.0, 133253.8], [1036.0, 103809.33333333333], [1034.0, 115414.5], [1032.0, 75986.25], [1144.0, 93850.66666666666], [1088.0, 83405.33333333334], [1092.0, 88705.4], [1090.0, 130273.16666666667], [1096.0, 106596.4], [1094.0, 94844.75], [1100.0, 134357.66666666666], [1098.0, 93234.5], [1118.0, 82503.0], [1116.0, 96148.5], [1114.0, 113427.66666666667], [1112.0, 125326.8], [1110.0, 105291.0], [1108.0, 127011.5], [1106.0, 92759.75], [1104.0, 50721.5], [1102.0, 110753.0], [1150.0, 102218.8], [1122.0, 118102.75], [1120.0, 89601.2], [1126.0, 104994.0909090909], [1124.0, 115906.16666666667], [1130.0, 57323.333333333336], [1128.0, 143342.0], [1134.0, 89437.0], [1132.0, 61696.75], [1148.0, 49678.333333333336], [1146.0, 82595.25], [1142.0, 106907.4], [1140.0, 115011.66666666667], [1138.0, 91244.5], [1136.0, 127619.75], [1202.0, 56773.49999999999], [1182.0, 75608.8], [1158.0, 99795.0], [1156.0, 90904.16666666667], [1154.0, 105281.75], [1152.0, 131418.75], [1180.0, 73554.6], [1178.0, 102899.5], [1160.0, 34959.0], [1162.0, 81917.6], [1164.0, 88739.0], [1200.0, 63660.28571428572], [1166.0, 50299.333333333336], [1184.0, 75849.0], [1204.0, 88705.5], [1206.0, 105947.0], [1210.0, 58333.75], [1208.0, 79887.5], [1214.0, 69262.33333333333], [1212.0, 83373.8], [1186.0, 94232.83333333333], [1188.0, 83699.0], [1190.0, 89169.5], [1196.0, 57687.375], [1194.0, 101660.0], [1192.0, 90654.37500000001], [1198.0, 63603.25], [1172.0, 66584.4], [1170.0, 92286.66666666667], [1168.0, 93230.0], [1174.0, 69602.66666666667], [1176.0, 101206.0], [1226.0, 57521.0], [1270.0, 51774.4], [1220.0, 63539.333333333336], [1218.0, 115726.75], [1216.0, 58164.5], [1224.0, 74290.33333333333], [1222.0, 67654.0], [1230.0, 54029.25], [1228.0, 50866.666666666664], [1264.0, 74387.6], [1268.0, 102256.8], [1266.0, 92124.0], [1232.0, 71896.14285714286], [1236.0, 73213.75], [1234.0, 80663.66666666667], [1240.0, 44090.6], [1238.0, 60572.25], [1244.0, 73656.8], [1242.0, 72863.8], [1246.0, 76924.14285714286], [1248.0, 83279.66666666667], [1252.0, 60609.5], [1250.0, 47719.166666666664], [1278.0, 71191.33333333333], [1276.0, 43447.0], [1274.0, 71197.66666666667], [1272.0, 77641.6], [1254.0, 57874.0], [1260.0, 50824.4], [1258.0, 43661.75], [1256.0, 53005.0], [1262.0, 89511.5], [1328.0, 85597.5], [1306.0, 54546.16666666667], [1286.0, 52544.28571428572], [1284.0, 71624.5], [1282.0, 75819.71428571429], [1280.0, 115784.33333333334], [1288.0, 61159.8], [1292.0, 57098.2], [1294.0, 40150.75], [1290.0, 48484.18181818182], [1310.0, 99392.55555555556], [1308.0, 95852.33333333334], [1330.0, 50807.11111111111], [1334.0, 64162.375], [1332.0, 40866.833333333336], [1296.0, 44350.66666666667], [1298.0, 72613.57142857143], [1300.0, 59905.27272727273], [1304.0, 77668.2], [1302.0, 54238.833333333336], [1312.0, 54130.8], [1320.0, 45144.700000000004], [1322.0, 45940.5], [1318.0, 64848.0], [1316.0, 53839.83333333333], [1314.0, 62181.142857142855], [1326.0, 48492.66666666667], [1324.0, 43871.666666666664], [1336.0, 49243.666666666664], [1338.0, 58438.85714285714], [1342.0, 53140.7], [1340.0, 68642.5], [1400.0, 82384.0], [1346.0, 45894.818181818184], [1344.0, 69991.36363636363], [1354.0, 70402.14285714286], [1352.0, 46314.153846153844], [1350.0, 74860.00000000001], [1348.0, 75605.6], [1356.0, 64481.727272727265], [1358.0, 56724.28571428572], [1394.0, 57312.47368421052], [1392.0, 58910.69999999999], [1398.0, 86453.0], [1396.0, 81242.4], [1406.0, 59019.333333333336], [1376.0, 49202.583333333336], [1380.0, 52514.866666666654], [1378.0, 50123.235294117636], [1384.0, 92450.83333333334], [1382.0, 63427.0], [1404.0, 41993.9], [1402.0, 66088.625], [1386.0, 42196.77272727273], [1390.0, 43372.954545454544], [1388.0, 74390.6], [1362.0, 44868.0], [1360.0, 52436.55555555555], [1364.0, 54047.36363636364], [1366.0, 30357.585365853654], [1370.0, 54168.72727272727], [1368.0, 55611.74999999999], [1372.0, 60750.833333333336], [1374.0, 49493.65517241378], [1416.0, 79748.28571428571], [1436.0, 31622.999999999996], [1412.0, 46840.71428571429], [1408.0, 59055.77777777778], [1410.0, 180023.0], [1414.0, 55837.22222222222], [1418.0, 50177.0], [1422.0, 95099.0], [1458.0, 79190.0], [1456.0, 101196.0], [1462.0, 101916.0], [1460.0, 102083.0], [1466.0, 51711.5], [1464.0, 162088.0], [1440.0, 78418.0], [1442.0, 61523.5], [1444.0, 77171.0], [1448.0, 88809.0], [1450.0, 101571.66666666667], [1454.0, 66267.5], [1452.0, 180018.0], [1446.0, 101969.0], [1420.0, 104314.0], [1434.0, 49759.0], [1432.0, 138405.0], [1438.0, 34781.454545454544], [1430.0, 105115.0], [1428.0, 35859.73684210527], [1426.0, 37437.166666666664], [1424.0, 64116.75], [1081.0, 103516.33333333333], [1061.0, 73209.0], [1033.0, 94993.0], [1085.0, 62998.166666666664], [1083.0, 98125.2], [1077.0, 153188.25], [1079.0, 68421.5], [1075.0, 91970.875], [1073.0, 124978.66666666667], [1039.0, 115362.5], [1037.0, 131971.0], [1035.0, 111090.0], [1087.0, 123241.66666666666], [1059.0, 91699.33333333333], [1057.0, 105879.0], [1053.0, 77326.0], [1051.0, 128376.25], [1049.0, 147590.4], [1047.0, 104234.25], [1045.0, 87005.33333333334], [1041.0, 110601.75], [1043.0, 151004.33333333334], [1055.0, 64780.833333333336], [1027.0, 101776.79999999999], [1025.0, 116010.66666666666], [1031.0, 133320.2], [1029.0, 132077.0], [1065.0, 103241.0], [1067.0, 104420.4], [1069.0, 103319.42857142857], [1071.0, 81551.6], [1063.0, 113843.6], [1143.0, 92481.85714285714], [1119.0, 76446.2], [1091.0, 78850.14285714286], [1089.0, 60905.75], [1095.0, 136059.66666666666], [1093.0, 83965.0], [1099.0, 89894.0], [1097.0, 131467.33333333334], [1137.0, 136647.6], [1103.0, 107229.33333333333], [1101.0, 110454.0], [1141.0, 89327.66666666666], [1139.0, 61174.25], [1107.0, 82696.33333333334], [1105.0, 132741.0], [1109.0, 95227.16666666667], [1117.0, 50082.83333333333], [1115.0, 89623.33333333334], [1113.0, 99014.0], [1111.0, 90195.33333333333], [1147.0, 60180.33333333333], [1145.0, 135338.0], [1151.0, 73401.2], [1123.0, 121642.33333333333], [1121.0, 82760.0], [1127.0, 106454.0], [1125.0, 117708.25], [1131.0, 58726.666666666664], [1129.0, 84280.57142857143], [1135.0, 82659.83333333333], [1133.0, 129074.66666666666], [1149.0, 55509.25], [1163.0, 89950.8], [1205.0, 44454.16666666667], [1167.0, 58949.71428571428], [1165.0, 104114.5], [1203.0, 57618.0], [1201.0, 128875.0], [1183.0, 50082.0], [1153.0, 88438.4], [1157.0, 48529.5], [1155.0, 92100.0], [1161.0, 79849.75], [1159.0, 47135.0], [1215.0, 79119.16666666667], [1207.0, 52583.2], [1213.0, 94034.0], [1211.0, 86910.0], [1209.0, 75718.11111111111], [1187.0, 58510.333333333336], [1185.0, 88747.25], [1193.0, 73711.4], [1191.0, 103085.0], [1195.0, 145359.0], [1199.0, 74115.33333333333], [1197.0, 86450.0], [1189.0, 82107.66666666667], [1173.0, 117178.6], [1171.0, 86924.0], [1169.0, 40602.333333333336], [1179.0, 67546.5], [1177.0, 70127.0], [1175.0, 27769.0], [1181.0, 45239.4], [1267.0, 46935.833333333336], [1277.0, 82288.83333333333], [1237.0, 48668.2], [1235.0, 110824.0], [1233.0, 69467.75], [1241.0, 57037.25], [1239.0, 62285.25], [1245.0, 84791.0], [1243.0, 52714.28571428572], [1265.0, 61384.5], [1231.0, 49150.5], [1229.0, 66416.0], [1227.0, 84768.5], [1225.0, 79367.75], [1223.0, 63214.0], [1221.0, 113545.33333333333], [1219.0, 114658.6], [1217.0, 52570.0], [1247.0, 80008.33333333333], [1249.0, 87497.5], [1253.0, 53816.0], [1251.0, 63296.25], [1257.0, 131361.33333333334], [1255.0, 51382.0], [1261.0, 97148.5], [1263.0, 38315.333333333336], [1259.0, 68718.2], [1279.0, 71161.16666666666], [1275.0, 59875.71428571428], [1273.0, 67927.0], [1271.0, 52746.4], [1269.0, 91417.0], [1333.0, 43976.5], [1285.0, 73335.14285714286], [1293.0, 49363.28571428572], [1291.0, 67088.5], [1289.0, 61150.0], [1287.0, 80436.75], [1295.0, 51874.125], [1331.0, 51716.307692307695], [1329.0, 80190.0], [1307.0, 47536.38461538461], [1305.0, 83408.45454545454], [1303.0, 49119.57142857143], [1301.0, 69932.0], [1299.0, 61631.42857142857], [1297.0, 56422.76923076923], [1311.0, 84624.8], [1283.0, 110446.59999999999], [1281.0, 59062.11111111111], [1309.0, 83989.27272727272], [1313.0, 59249.8], [1319.0, 55556.0], [1317.0, 51066.41666666668], [1315.0, 56990.75], [1321.0, 71858.33333333333], [1325.0, 51397.833333333336], [1327.0, 46787.0], [1323.0, 73566.625], [1341.0, 52201.66666666667], [1343.0, 48674.00000000001], [1339.0, 66219.66666666667], [1337.0, 64442.57142857143], [1335.0, 70033.54545454546], [1399.0, 51961.0], [1357.0, 57983.54545454545], [1347.0, 58889.399999999994], [1345.0, 56728.428571428565], [1351.0, 57109.0], [1349.0, 51516.105263157886], [1355.0, 58435.49999999999], [1353.0, 89480.83333333334], [1375.0, 47996.28571428572], [1373.0, 78779.0], [1371.0, 51006.41176470589], [1359.0, 46927.93333333333], [1393.0, 44383.722222222226], [1397.0, 52822.0], [1395.0, 54953.61111111111], [1363.0, 50573.42857142857], [1361.0, 57704.42857142858], [1367.0, 55342.90000000001], [1365.0, 53068.625], [1369.0, 67564.91304347827], [1391.0, 42638.69565217391], [1389.0, 46614.72727272728], [1387.0, 52158.73333333333], [1385.0, 73857.83333333334], [1383.0, 46978.47619047619], [1381.0, 65381.375], [1379.0, 61740.0], [1377.0, 48341.22727272728], [1407.0, 37519.09090909091], [1405.0, 53889.7], [1403.0, 45622.22222222222], [1401.0, 52181.27272727273], [1415.0, 60924.857142857145], [1433.0, 66284.57142857143], [1413.0, 46653.33333333333], [1411.0, 41770.41666666667], [1409.0, 47156.933333333334], [1417.0, 141347.5], [1419.0, 56621.142857142855], [1423.0, 37727.71428571429], [1457.0, 102002.0], [1459.0, 60632.5], [1465.0, 135922.5], [1463.0, 162205.0], [1461.0, 180013.0], [1441.0, 60791.0], [1445.0, 70671.33333333333], [1443.0, 47621.33333333333], [1447.0, 100252.66666666667], [1449.0, 79746.0], [1451.0, 102224.0], [1453.0, 140986.5], [1455.0, 101230.0], [1421.0, 180025.5], [1425.0, 44467.0], [1427.0, 114670.5], [1431.0, 61565.66666666667], [1429.0, 64635.5], [1439.0, 34025.47826086956], [1435.0, 40235.16666666667], [1437.0, 120804.0], [1.0, 134585.0]], "isOverall": false, "label": "HTTP Request", "isController": false}, {"data": [[951.7451863354025, 71032.95683229814]], "isOverall": false, "label": "HTTP Request-Aggregated", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 1466.0, "title": "Time VS Threads"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: { noColumns: 2,show: true, container: '#legendTimeVsThreads' },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s: At %x.2 active threads, Average response time was %y.2 ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesTimeVsThreads"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotTimesVsThreads"), dataset, options);
            // setup overview
            $.plot($("#overviewTimesVsThreads"), dataset, prepareOverviewOptions(options));
        }
};

// Time vs threads
function refreshTimeVsThreads(){
    var infos = timeVsThreadsInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTimeVsThreads");
        return;
    }
    if(isGraph($("#flotTimesVsThreads"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTimeVsThreads");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTimesVsThreads", "#overviewTimesVsThreads");
        $('#footerTimeVsThreads .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var bytesThroughputOverTimeInfos = {
        data : {"result": {"minY": 744.2, "minX": 1.69659996E12, "maxY": 2665.4, "series": [{"data": [[1.69660044E12, 744.2], [1.69660008E12, 1598.6], [1.69660014E12, 2303.4], [1.69660026E12, 2383.8], [1.69659996E12, 1309.65], [1.6966002E12, 2176.0], [1.69660002E12, 1852.8], [1.69660038E12, 2665.4], [1.69660032E12, 1961.2]], "isOverall": false, "label": "Bytes received per second", "isController": false}, {"data": [[1.69660044E12, 764.6666666666666], [1.69660008E12, 1717.9166666666667], [1.69660014E12, 2286.25], [1.69660026E12, 2188.0833333333335], [1.69659996E12, 1250.3333333333333], [1.6966002E12, 2084.75], [1.69660002E12, 1994.3333333333333], [1.69660038E12, 2379.25], [1.69660032E12, 1971.0833333333333]], "isOverall": false, "label": "Bytes sent per second", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69660044E12, "title": "Bytes Throughput Over Time"}},
        getOptions : function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity) ,
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Bytes / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendBytesThroughputOverTime'
                },
                selection: {
                    mode: "xy"
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y"
                }
            };
        },
        createGraph : function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesBytesThroughputOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotBytesThroughputOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewBytesThroughputOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Bytes throughput Over Time
function refreshBytesThroughputOverTime(fixTimestamps) {
    var infos = bytesThroughputOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotBytesThroughputOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesBytesThroughputOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotBytesThroughputOverTime", "#overviewBytesThroughputOverTime");
        $('#footerBytesThroughputOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimesOverTimeInfos = {
        data: {"result": {"minY": 2873.2128099173565, "minX": 1.69659996E12, "maxY": 136122.20270270272, "series": [{"data": [[1.69660044E12, 136122.20270270272], [1.69660008E12, 45584.419548872145], [1.69660014E12, 67470.14689265542], [1.69660026E12, 98484.10979929156], [1.69659996E12, 2873.2128099173565], [1.6966002E12, 73078.27881040888], [1.69660002E12, 30792.30310880831], [1.69660038E12, 112997.19761129192], [1.69660032E12, 72755.47444298823]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69660044E12, "title": "Response Time Over Time"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average response time was %y ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Times Over Time
function refreshResponseTimeOverTime(fixTimestamps) {
    var infos = responseTimesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotResponseTimesOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesOverTime", "#overviewResponseTimesOverTime");
        $('#footerResponseTimesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var latenciesOverTimeInfos = {
        data: {"result": {"minY": 2872.9876033057876, "minX": 1.69659996E12, "maxY": 136122.18581081086, "series": [{"data": [[1.69660044E12, 136122.18581081086], [1.69660008E12, 45584.3533834587], [1.69660014E12, 67470.10508474582], [1.69660026E12, 98484.06493506489], [1.69659996E12, 2872.9876033057876], [1.6966002E12, 73078.24411400253], [1.69660002E12, 30792.256476683946], [1.69660038E12, 112997.15526601498], [1.69660032E12, 72755.44167758837]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69660044E12, "title": "Latencies Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response latencies in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendLatenciesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average latency was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesLatenciesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotLatenciesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewLatenciesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Latencies Over Time
function refreshLatenciesOverTime(fixTimestamps) {
    var infos = latenciesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyLatenciesOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotLatenciesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesLatenciesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotLatenciesOverTime", "#overviewLatenciesOverTime");
        $('#footerLatenciesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var connectTimeOverTimeInfos = {
        data: {"result": {"minY": 2.3277027027027017, "minX": 1.69659996E12, "maxY": 4.167355371900823, "series": [{"data": [[1.69660044E12, 2.3277027027027017], [1.69660008E12, 2.4796992481202977], [1.69660014E12, 2.6316384180790964], [1.69660026E12, 2.489964580873672], [1.69659996E12, 4.167355371900823], [1.6966002E12, 2.5452292441139983], [1.69660002E12, 2.8601036269430047], [1.69660038E12, 2.3919652551574373], [1.69660032E12, 2.5688073394495428]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69660044E12, "title": "Connect Time Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getConnectTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average Connect Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendConnectTimeOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average connect time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesConnectTimeOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotConnectTimeOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewConnectTimeOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Connect Time Over Time
function refreshConnectTimeOverTime(fixTimestamps) {
    var infos = connectTimeOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyConnectTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotConnectTimeOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesConnectTimeOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotConnectTimeOverTime", "#overviewConnectTimeOverTime");
        $('#footerConnectTimeOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var responseTimePercentilesOverTimeInfos = {
        data: {"result": {"minY": 187.0, "minX": 1.69659996E12, "maxY": 180022.0, "series": [{"data": [[1.69660044E12, 167604.0], [1.69660008E12, 119680.0], [1.69660014E12, 169266.0], [1.69660026E12, 180014.0], [1.69659996E12, 9187.0], [1.6966002E12, 164599.0], [1.69660002E12, 60321.0], [1.69660038E12, 180022.0], [1.69660032E12, 173792.0]], "isOverall": false, "label": "Max", "isController": false}, {"data": [[1.69660044E12, 161341.4], [1.69660008E12, 71269.0], [1.69660014E12, 140525.10000000024], [1.69660026E12, 171125.9], [1.69659996E12, 5812.8], [1.6966002E12, 95936.0], [1.69660002E12, 49426.3], [1.69660038E12, 169317.7], [1.69660032E12, 104974.2]], "isOverall": false, "label": "90th percentile", "isController": false}, {"data": [[1.69660044E12, 167032.2], [1.69660008E12, 82467.20000000003], [1.69660014E12, 166681.96000000002], [1.69660026E12, 178129.35], [1.69659996E12, 8585.32], [1.6966002E12, 154210.28], [1.69660002E12, 58785.83999999999], [1.69660038E12, 178837.88], [1.69660032E12, 167353.00000000003]], "isOverall": false, "label": "99th percentile", "isController": false}, {"data": [[1.69660044E12, 164596.2], [1.69660008E12, 75249.0], [1.69660014E12, 161402.6], [1.69660026E12, 173451.5], [1.69659996E12, 7038.2], [1.6966002E12, 98377.6], [1.69660002E12, 52039.749999999985], [1.69660038E12, 174183.8], [1.69660032E12, 136797.3]], "isOverall": false, "label": "95th percentile", "isController": false}, {"data": [[1.69660044E12, 101208.0], [1.69660008E12, 187.0], [1.69660014E12, 9988.0], [1.69660026E12, 6704.0], [1.69659996E12, 494.0], [1.6966002E12, 4975.0], [1.69660002E12, 3718.0], [1.69660038E12, 13296.0], [1.69660032E12, 6135.0]], "isOverall": false, "label": "Min", "isController": false}, {"data": [[1.69660044E12, 120401.0], [1.69660008E12, 58790.0], [1.69660014E12, 44739.5], [1.69660026E12, 53427.0], [1.69659996E12, 2868.0], [1.6966002E12, 39502.0], [1.69660002E12, 32178.0], [1.69660038E12, 97820.0], [1.69660032E12, 46364.0]], "isOverall": false, "label": "Median", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69660044E12, "title": "Response Time Percentiles Over Time (successful requests only)"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Response Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentilesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Response time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentilesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimePercentilesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimePercentilesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Time Percentiles Over Time
function refreshResponseTimePercentilesOverTime(fixTimestamps) {
    var infos = responseTimePercentilesOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotResponseTimePercentilesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimePercentilesOverTime", "#overviewResponseTimePercentilesOverTime");
        $('#footerResponseTimePercentilesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var responseTimeVsRequestInfos = {
    data: {"result": {"minY": 90.5, "minX": 1.0, "maxY": 180026.0, "series": [{"data": [[2.0, 63363.0], [32.0, 151863.5], [35.0, 1262.0], [38.0, 2546.5], [40.0, 1476.0], [41.0, 4403.0], [43.0, 2964.0], [3.0, 3961.0], [51.0, 3008.0], [52.0, 146457.0], [59.0, 13397.0], [4.0, 120091.0], [5.0, 118740.0], [6.0, 70407.0], [107.0, 2755.0], [7.0, 45049.0], [8.0, 42206.5], [9.0, 39367.0], [10.0, 51219.0], [11.0, 47418.0], [12.0, 50381.5], [13.0, 44096.0], [14.0, 46503.5], [15.0, 53570.0], [16.0, 45088.0], [1.0, 120107.0], [17.0, 55052.0], [18.0, 56725.0], [19.0, 50263.0], [20.0, 38003.0], [21.0, 83288.0], [22.0, 55527.0], [23.0, 50160.5], [24.0, 42164.5], [25.0, 96146.0], [26.0, 82187.0], [27.0, 72053.5], [28.0, 65509.5], [29.0, 49091.0], [30.0, 99071.5], [31.0, 29506.0]], "isOverall": false, "label": "Successes", "isController": false}, {"data": [[35.0, 90.5], [4.0, 180026.0], [5.0, 180007.5], [6.0, 180017.0], [107.0, 369.0], [7.0, 180019.0], [8.0, 180018.0], [9.0, 180016.0], [10.0, 180013.0], [11.0, 180011.0], [12.0, 180015.5], [13.0, 180013.5], [14.0, 180015.5], [15.0, 180010.5], [16.0, 180011.0], [17.0, 180011.0], [18.0, 180013.0], [19.0, 180013.0], [20.0, 180009.0], [21.0, 180013.0], [22.0, 180008.0], [23.0, 180011.0], [25.0, 180021.0], [26.0, 180012.0], [29.0, 180026.0], [30.0, 180014.0]], "isOverall": false, "label": "Failures", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 107.0, "title": "Response Time Vs Request"}},
    getOptions: function() {
        return {
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Response Time in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: {
                noColumns: 2,
                show: true,
                container: '#legendResponseTimeVsRequest'
            },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median response time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesResponseTimeVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotResponseTimeVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewResponseTimeVsRequest"), dataset, prepareOverviewOptions(options));

    }
};

// Response Time vs Request
function refreshResponseTimeVsRequest() {
    var infos = responseTimeVsRequestInfos;
    prepareSeries(infos.data);
    if (isGraph($("#flotResponseTimeVsRequest"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeVsRequest");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimeVsRequest", "#overviewResponseTimeVsRequest");
        $('#footerResponseRimeVsRequest .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var latenciesVsRequestInfos = {
    data: {"result": {"minY": 90.5, "minX": 1.0, "maxY": 180026.0, "series": [{"data": [[2.0, 63363.0], [32.0, 151863.5], [35.0, 1262.0], [38.0, 2546.5], [40.0, 1476.0], [41.0, 4403.0], [43.0, 2964.0], [3.0, 3961.0], [51.0, 3008.0], [52.0, 146457.0], [59.0, 13397.0], [4.0, 120091.0], [5.0, 118740.0], [6.0, 70407.0], [107.0, 2755.0], [7.0, 45049.0], [8.0, 42206.5], [9.0, 39367.0], [10.0, 51219.0], [11.0, 47418.0], [12.0, 50381.0], [13.0, 44096.0], [14.0, 46503.5], [15.0, 53570.0], [16.0, 45088.0], [1.0, 120107.0], [17.0, 55052.0], [18.0, 56725.0], [19.0, 50263.0], [20.0, 38003.0], [21.0, 83288.0], [22.0, 55527.0], [23.0, 50160.5], [24.0, 42164.5], [25.0, 96146.0], [26.0, 82187.0], [27.0, 72053.5], [28.0, 65509.5], [29.0, 49091.0], [30.0, 99071.5], [31.0, 29506.0]], "isOverall": false, "label": "Successes", "isController": false}, {"data": [[35.0, 90.5], [4.0, 180025.0], [5.0, 180007.5], [6.0, 180017.0], [107.0, 369.0], [7.0, 180019.0], [8.0, 180018.0], [9.0, 180016.0], [10.0, 180013.0], [11.0, 180011.0], [12.0, 180015.5], [13.0, 180013.5], [14.0, 180015.5], [15.0, 180010.5], [16.0, 180011.0], [17.0, 180011.0], [18.0, 180012.0], [19.0, 180013.0], [20.0, 180009.0], [21.0, 180013.0], [22.0, 180008.0], [23.0, 180011.0], [25.0, 180021.0], [26.0, 180012.0], [29.0, 180026.0], [30.0, 180014.0]], "isOverall": false, "label": "Failures", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 107.0, "title": "Latencies Vs Request"}},
    getOptions: function() {
        return{
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Latency in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: { noColumns: 2,show: true, container: '#legendLatencyVsRequest' },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median Latency time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesLatencyVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotLatenciesVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewLatenciesVsRequest"), dataset, prepareOverviewOptions(options));
    }
};

// Latencies vs Request
function refreshLatenciesVsRequest() {
        var infos = latenciesVsRequestInfos;
        prepareSeries(infos.data);
        if(isGraph($("#flotLatenciesVsRequest"))){
            infos.createGraph();
        }else{
            var choiceContainer = $("#choicesLatencyVsRequest");
            createLegend(choiceContainer, infos);
            infos.createGraph();
            setGraphZoomable("#flotLatenciesVsRequest", "#overviewLatenciesVsRequest");
            $('#footerLatenciesVsRequest .legendColorBox > div').each(function(i){
                $(this).clone().prependTo(choiceContainer.find("li").eq(i));
            });
        }
};

var hitsPerSecondInfos = {
        data: {"result": {"minY": 5.616666666666666, "minX": 1.69659996E12, "maxY": 22.333333333333332, "series": [{"data": [[1.69660008E12, 20.95], [1.69660014E12, 5.616666666666666], [1.69660026E12, 10.45], [1.69659996E12, 16.766666666666666], [1.6966002E12, 22.333333333333332], [1.69660002E12, 17.516666666666666], [1.69660032E12, 13.7]], "isOverall": false, "label": "hitsPerSecond", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69660032E12, "title": "Hits Per Second"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of hits / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendHitsPerSecond"
                },
                selection: {
                    mode : 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y.2 hits/sec"
                }
            };
        },
        createGraph: function createGraph() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesHitsPerSecond"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotHitsPerSecond"), dataset, options);
            // setup overview
            $.plot($("#overviewHitsPerSecond"), dataset, prepareOverviewOptions(options));
        }
};

// Hits per second
function refreshHitsPerSecond(fixTimestamps) {
    var infos = hitsPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if (isGraph($("#flotHitsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesHitsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotHitsPerSecond", "#overviewHitsPerSecond");
        $('#footerHitsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var codesPerSecondInfos = {
        data: {"result": {"minY": 0.016666666666666666, "minX": 1.69659996E12, "maxY": 13.6, "series": [{"data": [[1.69660044E12, 4.716666666666667], [1.69660008E12, 11.066666666666666], [1.69660014E12, 13.6], [1.69660026E12, 11.866666666666667], [1.69659996E12, 7.016666666666667], [1.6966002E12, 11.916666666666666], [1.69660002E12, 12.866666666666667], [1.69660038E12, 12.433333333333334], [1.69660032E12, 11.883333333333333]], "isOverall": false, "label": "200", "isController": false}, {"data": [[1.69659996E12, 1.05]], "isOverall": false, "label": "502", "isController": false}, {"data": [[1.69660044E12, 0.21666666666666667], [1.69660008E12, 0.016666666666666666], [1.69660014E12, 1.15], [1.69660026E12, 2.25], [1.6966002E12, 1.5333333333333334], [1.69660038E12, 2.9166666666666665], [1.69660032E12, 0.8333333333333334]], "isOverall": false, "label": "504", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69660044E12, "title": "Codes Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendCodesPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "Number of Response Codes %s at %x was %y.2 responses / sec"
                }
            };
        },
    createGraph: function() {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesCodesPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotCodesPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewCodesPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Codes per second
function refreshCodesPerSecond(fixTimestamps) {
    var infos = codesPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotCodesPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesCodesPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotCodesPerSecond", "#overviewCodesPerSecond");
        $('#footerCodesPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var transactionsPerSecondInfos = {
        data: {"result": {"minY": 0.016666666666666666, "minX": 1.69659996E12, "maxY": 13.6, "series": [{"data": [[1.69660044E12, 4.716666666666667], [1.69660008E12, 11.066666666666666], [1.69660014E12, 13.6], [1.69660026E12, 11.866666666666667], [1.69659996E12, 7.016666666666667], [1.6966002E12, 11.916666666666666], [1.69660002E12, 12.866666666666667], [1.69660038E12, 12.433333333333334], [1.69660032E12, 11.883333333333333]], "isOverall": false, "label": "HTTP Request-success", "isController": false}, {"data": [[1.69660044E12, 0.21666666666666667], [1.69660008E12, 0.016666666666666666], [1.69660014E12, 1.15], [1.69660026E12, 2.25], [1.69659996E12, 1.05], [1.6966002E12, 1.5333333333333334], [1.69660038E12, 2.9166666666666665], [1.69660032E12, 0.8333333333333334]], "isOverall": false, "label": "HTTP Request-failure", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69660044E12, "title": "Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTransactionsPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                }
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTransactionsPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTransactionsPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewTransactionsPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Transactions per second
function refreshTransactionsPerSecond(fixTimestamps) {
    var infos = transactionsPerSecondInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTransactionsPerSecond");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotTransactionsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTransactionsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTransactionsPerSecond", "#overviewTransactionsPerSecond");
        $('#footerTransactionsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var totalTPSInfos = {
        data: {"result": {"minY": 0.016666666666666666, "minX": 1.69659996E12, "maxY": 13.6, "series": [{"data": [[1.69660044E12, 4.716666666666667], [1.69660008E12, 11.066666666666666], [1.69660014E12, 13.6], [1.69660026E12, 11.866666666666667], [1.69659996E12, 7.016666666666667], [1.6966002E12, 11.916666666666666], [1.69660002E12, 12.866666666666667], [1.69660038E12, 12.433333333333334], [1.69660032E12, 11.883333333333333]], "isOverall": false, "label": "Transaction-success", "isController": false}, {"data": [[1.69660044E12, 0.21666666666666667], [1.69660008E12, 0.016666666666666666], [1.69660014E12, 1.15], [1.69660026E12, 2.25], [1.69659996E12, 1.05], [1.6966002E12, 1.5333333333333334], [1.69660038E12, 2.9166666666666665], [1.69660032E12, 0.8333333333333334]], "isOverall": false, "label": "Transaction-failure", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69660044E12, "title": "Total Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTotalTPS"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                },
                colors: ["#9ACD32", "#FF6347"]
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTotalTPS"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTotalTPS"), dataset, options);
        // setup overview
        $.plot($("#overviewTotalTPS"), dataset, prepareOverviewOptions(options));
    }
};

// Total Transactions per second
function refreshTotalTPS(fixTimestamps) {
    var infos = totalTPSInfos;
    // We want to ignore seriesFilter
    prepareSeries(infos.data, false, true);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotTotalTPS"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTotalTPS");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTotalTPS", "#overviewTotalTPS");
        $('#footerTotalTPS .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

// Collapse the graph matching the specified DOM element depending the collapsed
// status
function collapse(elem, collapsed){
    if(collapsed){
        $(elem).parent().find(".fa-chevron-up").removeClass("fa-chevron-up").addClass("fa-chevron-down");
    } else {
        $(elem).parent().find(".fa-chevron-down").removeClass("fa-chevron-down").addClass("fa-chevron-up");
        if (elem.id == "bodyBytesThroughputOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshBytesThroughputOverTime(true);
            }
            document.location.href="#bytesThroughputOverTime";
        } else if (elem.id == "bodyLatenciesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesOverTime(true);
            }
            document.location.href="#latenciesOverTime";
        } else if (elem.id == "bodyCustomGraph") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCustomGraph(true);
            }
            document.location.href="#responseCustomGraph";
        } else if (elem.id == "bodyConnectTimeOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshConnectTimeOverTime(true);
            }
            document.location.href="#connectTimeOverTime";
        } else if (elem.id == "bodyResponseTimePercentilesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimePercentilesOverTime(true);
            }
            document.location.href="#responseTimePercentilesOverTime";
        } else if (elem.id == "bodyResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeDistribution();
            }
            document.location.href="#responseTimeDistribution" ;
        } else if (elem.id == "bodySyntheticResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshSyntheticResponseTimeDistribution();
            }
            document.location.href="#syntheticResponseTimeDistribution" ;
        } else if (elem.id == "bodyActiveThreadsOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshActiveThreadsOverTime(true);
            }
            document.location.href="#activeThreadsOverTime";
        } else if (elem.id == "bodyTimeVsThreads") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTimeVsThreads();
            }
            document.location.href="#timeVsThreads" ;
        } else if (elem.id == "bodyCodesPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCodesPerSecond(true);
            }
            document.location.href="#codesPerSecond";
        } else if (elem.id == "bodyTransactionsPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTransactionsPerSecond(true);
            }
            document.location.href="#transactionsPerSecond";
        } else if (elem.id == "bodyTotalTPS") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTotalTPS(true);
            }
            document.location.href="#totalTPS";
        } else if (elem.id == "bodyResponseTimeVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeVsRequest();
            }
            document.location.href="#responseTimeVsRequest";
        } else if (elem.id == "bodyLatenciesVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesVsRequest();
            }
            document.location.href="#latencyVsRequest";
        }
    }
}

/*
 * Activates or deactivates all series of the specified graph (represented by id parameter)
 * depending on checked argument.
 */
function toggleAll(id, checked){
    var placeholder = document.getElementById(id);

    var cases = $(placeholder).find(':checkbox');
    cases.prop('checked', checked);
    $(cases).parent().children().children().toggleClass("legend-disabled", !checked);

    var choiceContainer;
    if ( id == "choicesBytesThroughputOverTime"){
        choiceContainer = $("#choicesBytesThroughputOverTime");
        refreshBytesThroughputOverTime(false);
    } else if(id == "choicesResponseTimesOverTime"){
        choiceContainer = $("#choicesResponseTimesOverTime");
        refreshResponseTimeOverTime(false);
    }else if(id == "choicesResponseCustomGraph"){
        choiceContainer = $("#choicesResponseCustomGraph");
        refreshCustomGraph(false);
    } else if ( id == "choicesLatenciesOverTime"){
        choiceContainer = $("#choicesLatenciesOverTime");
        refreshLatenciesOverTime(false);
    } else if ( id == "choicesConnectTimeOverTime"){
        choiceContainer = $("#choicesConnectTimeOverTime");
        refreshConnectTimeOverTime(false);
    } else if ( id == "choicesResponseTimePercentilesOverTime"){
        choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        refreshResponseTimePercentilesOverTime(false);
    } else if ( id == "choicesResponseTimePercentiles"){
        choiceContainer = $("#choicesResponseTimePercentiles");
        refreshResponseTimePercentiles();
    } else if(id == "choicesActiveThreadsOverTime"){
        choiceContainer = $("#choicesActiveThreadsOverTime");
        refreshActiveThreadsOverTime(false);
    } else if ( id == "choicesTimeVsThreads"){
        choiceContainer = $("#choicesTimeVsThreads");
        refreshTimeVsThreads();
    } else if ( id == "choicesSyntheticResponseTimeDistribution"){
        choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        refreshSyntheticResponseTimeDistribution();
    } else if ( id == "choicesResponseTimeDistribution"){
        choiceContainer = $("#choicesResponseTimeDistribution");
        refreshResponseTimeDistribution();
    } else if ( id == "choicesHitsPerSecond"){
        choiceContainer = $("#choicesHitsPerSecond");
        refreshHitsPerSecond(false);
    } else if(id == "choicesCodesPerSecond"){
        choiceContainer = $("#choicesCodesPerSecond");
        refreshCodesPerSecond(false);
    } else if ( id == "choicesTransactionsPerSecond"){
        choiceContainer = $("#choicesTransactionsPerSecond");
        refreshTransactionsPerSecond(false);
    } else if ( id == "choicesTotalTPS"){
        choiceContainer = $("#choicesTotalTPS");
        refreshTotalTPS(false);
    } else if ( id == "choicesResponseTimeVsRequest"){
        choiceContainer = $("#choicesResponseTimeVsRequest");
        refreshResponseTimeVsRequest();
    } else if ( id == "choicesLatencyVsRequest"){
        choiceContainer = $("#choicesLatencyVsRequest");
        refreshLatenciesVsRequest();
    }
    var color = checked ? "black" : "#818181";
    if(choiceContainer != null) {
        choiceContainer.find("label").each(function(){
            this.style.color = color;
        });
    }
}

